#pragma once
#include <gtkmm.h>

#include "CKeyDialog.h"
#include "CProgressDialog.h"
#include "ilguard/ilg_cpp_helpers.h"
#include "ilguard/ilguard.h"
#include "types.h"

class CKeysDialog : public Gtk::Window {
public:
    CKeysDialog();
    ~CKeysDialog() override;

    void Init(const ilg::CController& oController);

protected:
    void on_in_selection_changed(guint position, guint n_items);
    void on_in_columnview_activate(guint n);
    void on_setup_label(const Glib::RefPtr<Gtk::ListItem>& list_item, Gtk::Align halign);
    void on_bind_idx(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_bind_key_number(const Glib::RefPtr<Gtk::ListItem>& list_item);
    bool number_transform_to(const GValue* a, GValue* b);
    void on_bind_type(const Glib::RefPtr<Gtk::ListItem>& list_item);
    bool type_transform_to(const GValue* a, GValue* b);
    void on_bind_access(const Glib::RefPtr<Gtk::ListItem>& list_item);
    bool access_transform_to(const GValue* a, GValue* b);
    void on_bind_cell(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_button_in_read();
    void on_button_in_clear();
    void on_button_in_add();
    void on_button_in_change();
    void on_button_in_delete();
    void on_out_selection_changed(guint position, guint n_items);
    void on_out_columnview_activate(guint n);
    void on_button_out_read();
    void on_button_out_clear();
    void on_button_out_add();
    void on_button_out_change();
    void on_button_out_delete();
    void on_progress_dialog_cancel();
    bool on_progress_dialog_progress(size_t& nCurrent, size_t& nTotal);
    void on_progress_dialog_hide();
    void on_key_dialog_hide();
    void on_hide();
    static void ILG_CALL on_ilg_message(ilg_controller_msg nMsg, const void* pMsgData,
                                        void* pUserData);
    void on_ilg();
    void on_ilg_command_finish(ilg_handle hCommand);
    void on_dialog_response(int);

    void StartReadKeys(int nBankN = -1);
    void StartClearKeys(int nBankN = -1);
    void DoChangeKey(bool fOut, int nKeyIdx = -1);
    void SetKeys(uint nBankIdx, const ilg_key* pList, size_t nCount);
    void ShowMessage(const std::string& sMessage, Gtk::MessageType nType = Gtk::MessageType::INFO);
    void UpdateInButtonState();
    void UpdateOutButtonState();
    const char* GetAccessStr(uint nAccess);

protected:
    // A Gio::ListStore item.
    class ModelColumns : public Glib::Object {
    public:
        Glib::Property<MyKeyNumber> m_property_number;
        Glib::Property<ilg_key_type> m_Type;
        Glib::Property<uint8_t> m_Access;
        Glib::Property<size_t> m_Cell;

        void SetNumber(const ilg_key_number& Number, uint8_t nFlags) {
            m_property_number = MyKeyNumber(Number, nFlags);
        }

        static Glib::RefPtr<ModelColumns> create(const ilg_key_number& Number, ilg_key_type nType,
                                                 uint8_t nAccess, uint8_t nFlags, size_t nCell) {
            return Glib::make_refptr_for_instance<ModelColumns>(
                new ModelColumns(Number, nType, nAccess, nFlags, nCell));
        }

    protected:
        ModelColumns(const ilg_key_number& Number, ilg_key_type nType, uint8_t nAccess,
                     uint8_t nFlags, size_t nCell) :
            Glib::ObjectBase(typeid(ModelColumns)),
            Glib::Object(),
            m_property_number(*this, "number", MyKeyNumber(Number, nFlags)),
            m_Type(*this, "type", nType),
            m_Access(*this, "access", nAccess),
            m_Cell(*this, "cell", nCell) {
        }
    };

    // Режим
    enum Mode {
        MODE_UNDEF,
        MODE_READ,
        MODE_CLEAR
    };

    ilg::CController m_oController;  // Контроллер
    bool m_fWiegand;
    size_t m_nMaxKeys;
    uint m_nBankCount;
    bool m_fScheduleInit;
    ilg_time_zone m_aTzs[2][7];
    std::string m_sTemp;

    Mode m_nMode;
    uint m_nReadBankIdx;  // Номер банка, из которого читаем ключи
    uint m_nReadBankCount;  // Количество банков, из которого читаем ключи
    size_t m_aReadCount[2];
    ilg::CAsyncCommand m_oCommand;

    Gtk::Box m_Box;
    Gtk::Frame m_InFrame;  // Группа "Вход"
    Gtk::Box m_InBox;
    Gtk::ScrolledWindow m_InScrolledWindow;
    Gtk::ColumnView m_InColumnView;
    Glib::RefPtr<Gio::ListStore<ModelColumns>> m_InListStore;
    Gtk::Grid m_InGrid;
    Gtk::Button m_InReadButton;    // Кнопка "Читать все"
    Gtk::Button m_InAddButton;     // Кнопка "Добавить..."
    Gtk::Button m_InChangeButton;  // Кнопка "Изменить..."
    Gtk::Button m_InDeleteButton;  // Кнопка "Удалить"
    Gtk::Button m_InClearButton;   // Кнопка "Очистить"
    Gtk::Frame m_OutFrame;         // Группа "Выход"
    Gtk::Box m_OutBox;
    Gtk::ScrolledWindow m_OutScrolledWindow;
    Gtk::ColumnView m_OutColumnView;
    Glib::RefPtr<Gio::ListStore<ModelColumns>> m_OutListStore;
    Gtk::Grid m_OutGrid;
    Gtk::Button m_OutReadButton;    // Кнопка "Читать все"
    Gtk::Button m_OutAddButton;     // Кнопка "Добавить..."
    Gtk::Button m_OutChangeButton;  // Кнопка "Изменить..."
    Gtk::Button m_OutDeleteButton;  // Кнопка "Удалить"
    Gtk::Button m_OutClearButton;   // Кнопка "Очистить"
    Glib::RefPtr<Gtk::MessageDialog> m_refDialog;
    Glib::RefPtr<CProgressDialog> m_refProgressDialog;
    Glib::RefPtr<CKeyDialog> m_refKeyDialog;
    Glib::Dispatcher m_oDisp;
};
