#include "utils.h"

const char* kReaderMode[] = {"Dallas", "Wiegand"};

const char* kControllerModeNames[] = {"Неактивный", "Обычный", "Блокировка", "Свободный",
                                      "Ожидание"};
static_assert(ILG_CONTROLLER_MODE_SIZE == 5);

const char* kPassPointTypeNames[] = {"",
                                     "Дверь",
                                     "Турникет",
                                     "Шлюз",
                                     "Шлагбаум",
                                     "Электромагнитный замок",
                                     "Электромеханический замок",
                                     "Турникет",
                                     "Моторный через два реле",
                                     "Моторный через одно реле",
                                     "Электроконтроль",
                                     "Автоконтроль"};
static_assert(ILG_PASS_POINT_SIZE == 12);

const char* kEventTypeNames[] = {"Неизвестное событие",
                                 "Открыто кнопкой изнутри",
                                 "Ключ не найден в банке ключей",
                                 "Ключ найден, дверь открыта",
                                 "Ключ найден, доступ не разрешен",
                                 "Открыто оператором по сети",
                                 "Ключ найден, дверь заблокирована",
                                 "Попытка открыть заблокированную дверь кнопкой",
                                 "Дверь взломана",
                                 "Дверь оставлена открытой (таймаут)",
                                 "Проход состоялся",
                                 "Перезагрузка контроллера",
                                 "Заблокирована кнопка открывания",
                                 "Попытка двойного прохода",
                                 "Дверь открыта",
                                 "Дверь закрыта",
                                 "Пропало питание",
                                 "Появилось питание",
                                 "Включение замка (триггер)",
                                 "Отключение замка (триггер)",
                                 "Изменено состояние режима \"Электроконтроль\"",
                                 "Переключение режима контроллера",
                                 "Изменено состояние режима \"Пожар\"",
                                 "Изменено состояние режима \"Охрана\"",
                                 "Совершён вход в шлюз",
                                 "Заблокирован вход в шлюз (занят)",
                                 "Разрешен вход в шлюз",
                                 "Заблокирован проход (Антипассбек)",
                                 "Hotel (Изменен режим работы)",
                                 "Hotel (Отработка карт)",
                                 "Номер ключа"};
static_assert(ILG_EVENT_TYPE_SIZE == 31);

const char* kDirectionNames[] = {"", "Вход", "Выход"};
static_assert(ILG_DIRECTION_SIZE == 3);

std::vector<uint8_t> decodeHex(const std::string& source) {
    if (std::string::npos != source.find_first_not_of("0123456789ABCDEFabcdef")) {
        // you can throw exception here
        return {};
    }

    union {
        uint64_t binary;
        char byte[8];
    } value{};

    auto size = source.size(), offset = (size % 16);
    std::vector<uint8_t> binary{};
    binary.reserve((size + 1) / 2);

    if (offset) {
        value.binary = std::stoull(source.substr(0, offset), nullptr, 16);

        for (auto index = (offset + 1) / 2; index--;) {
            binary.emplace_back(value.byte[index]);
        }
    }

    for (; offset < size; offset += 16) {
        value.binary = std::stoull(source.substr(offset, 16), nullptr, 16);
        for (auto index = 8; index--;) {
            binary.emplace_back(value.byte[index]);
        }
    }

    return binary;
}

void replaceAll(std::string& str, const std::string& from, const std::string& to) {
    if (from.empty())
        return;
    size_t start_pos = 0;
    while ((start_pos = str.find(from, start_pos)) != std::string::npos) {
        str.replace(start_pos, from.length(), to);
        start_pos += to.length();  // In case 'to' contains 'from', like replacing 'x' with 'yx'
    }
}

bool IsLeapYear(uint nYear) {
    return ((nYear % 4) == 0) && (((nYear % 100) != 0) || ((nYear % 400) == 0));
}
