#pragma once
#include <gtkmm.h>

#include "CProgressDialog.h"
#include "ilguard/ilg_cpp_helpers.h"
#include "ilguard/ilguard.h"
#include "types.h"

/**
 * Окно "Монитор событий" для просмотра событий контроллера в реальном времени
 */
class CMonitorDialog : public Gtk::Window {
public:
    CMonitorDialog();
    ~CMonitorDialog() override;

    void Init(const ilg::CController& oController);

protected:
    void on_setup_label(const Glib::RefPtr<Gtk::ListItem>& list_item, Gtk::Align halign);
    void on_bind_idx(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_bind_time(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_bind_event(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_bind_direction(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_bind_key(const Glib::RefPtr<Gtk::ListItem>& list_item);
    bool number_transform_to(const GValue* a, GValue* b);
    void on_bind_details(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_button_clear();
    void on_button_open_in();
    void on_button_open_out();
    void on_destroy();
    static void ILG_CALL on_ilg_message(ilg_controller_msg nMsg, const void* pMsgData,
                                        void* pUserData);
    void on_ilg();
    void on_ilg_command_finish(ilg_handle hCommand);
    void on_ilg_rtc_changed();

    void StartReadEvents();
    void AddEvents(const uint64_t* pList, size_t nCount);

protected:
    // A Gio::ListStore item.
    class CModelColumns : public Glib::Object {
    public:
        size_t m_nIdx;               // Позиция события в контроллере
        time_t m_tTime;              // Дата и время события
        ilg_event_type m_nType;      // Тип события
        ilg_event_format m_nFormat;  // Формат записи события
        ilg_direction m_nDirection;  // Направление
        Glib::Property<MyKeyNumber> m_property_number;
        uint8_t m_nModeFlags;         // Флаги режима
        uint8_t m_nModeTrigger;       // Триггер режима
        ilg_controller_mode m_nMode;  // Режим контроллера
        uint8_t m_nKeyBankN;          // Номер банка ключей
        ssize_t m_nKeyIdx;            // Позиция в банке ключей

        static Glib::RefPtr<CModelColumns> create(size_t nIdx, const time_t& tTime,
                                                  ilg_event_type nType, ilg_event_format nFormat,
                                                  ilg_direction nDirection, bool fKeyEmpty,
                                                  const ilg_key_number& rKeyNumber,
                                                  uint8_t nKeyFlags, uint8_t nModeFlags,
                                                  uint8_t nModeTrigger, ilg_controller_mode nMode,
                                                  uint8_t nKeyBankN, ssize_t nKeyIdx) {
            return Glib::make_refptr_for_instance<CModelColumns>(
                new CModelColumns(nIdx, tTime, nType, nFormat, nDirection, fKeyEmpty, rKeyNumber,
                                  nKeyFlags, nModeFlags, nModeTrigger, nMode, nKeyBankN, nKeyIdx));
        }

    protected:
        CModelColumns(size_t nIdx, const time_t& tTime, ilg_event_type nType,
                      ilg_event_format nFormat, ilg_direction nDirection, bool fKeyEmpty,
                      const ilg_key_number& rKeyNumber, uint8_t nKeyFlags, uint8_t nModeFlags,
                      uint8_t nModeTrigger, ilg_controller_mode nMode, uint8_t nKeyBankN,
                      ssize_t nKeyIdx) :
            Glib::ObjectBase(typeid(CModelColumns)),
            Glib::Object(),
            m_nIdx(nIdx),
            m_tTime(tTime),
            m_nType(nType),
            m_nFormat(nFormat),
            m_nDirection(nDirection),
            m_property_number(*this, "number",
                              fKeyEmpty ? MyKeyNumber() : MyKeyNumber(rKeyNumber, nKeyFlags)),
            m_nModeFlags(nModeFlags),
            m_nModeTrigger(nModeTrigger),
            m_nMode(nMode),
            m_nKeyBankN(nKeyBankN),
            m_nKeyIdx(nKeyIdx) {
        }
    };  // CModelColumns

    ilg::CController m_oController;  // Контроллер
    bool m_fWiegand;
    size_t m_nMaxEvents;
    ssize_t m_nReadIdx;
    ssize_t m_nWriteIdx;
    ilg::CAsyncCommand m_oCommand;

    Gtk::Box m_Box;
    Gtk::ScrolledWindow m_ScrolledWindow;
    Gtk::ColumnView m_ColumnView;  // Таблица
    Glib::RefPtr<Gio::ListStore<CModelColumns>> m_ListStore;
    Gtk::Box m_BottomBox;         // Нижняя панель с кнопками
    Gtk::Button m_ClearButton;    // Кнопка "Очистить"
    Gtk::Button m_OpenInButton;   // Кнопка "Открыть для входа"
    Gtk::Button m_OpenOutButton;  // Кнопка "Открыть для выхода"
    Gtk::Label m_LastKeyLabel;    // Метка "Последний ключ:"
    Gtk::Label m_LastKeyValueLabel;
    Glib::Dispatcher m_oDisp;
};
