#pragma once
#include <gtkmm.h>

#include "CProgressDialog.h"
#include "ilguard/ilg_cpp_helpers.h"
#include "ilguard/ilguard.h"
#include "types.h"

/**
 * Окно "События" для просмотра журнала контроллера
 */
class CEventsDialog : public Gtk::Window {
public:
    CEventsDialog();
    ~CEventsDialog() override;

    void Init(const ilg::CController& oController);

protected:
    void on_setup_label(const Glib::RefPtr<Gtk::ListItem>& list_item, Gtk::Align halign);
    void on_bind_idx(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_bind_time(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_bind_event(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_bind_direction(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_bind_key(const Glib::RefPtr<Gtk::ListItem>& list_item);
    bool number_transform_to(const GValue* a, GValue* b);
    void on_bind_details(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_button_read_all();
    void on_button_read_new();
    void on_button_read_idx();
    void on_button_write_idx();
    void on_progress_dialog_cancel();
    bool on_progress_dialog_progress(size_t& nCurrent, size_t& nTotal);
    void on_progress_dialog_hide();
    void on_dialog_response(int);
    void on_hide();
    static void ILG_CALL on_ilg_message(ilg_controller_msg nMsg, const void* pMsgData,
                                        void* pUserData);
    void on_ilg();
    void on_ilg_command_finish(ilg_handle hCommand);

    // Запускает чтение событий в фоновом режиме
    void StartReadEvents(size_t nIdx, size_t nCount);
    // Устанавливает список событий в таблицу
    void SetEvents(size_t nStart, const uint64_t* pList, size_t nCount);
    // Запускает чтение ключей для событий в фоновом режиме
    void StartReadKeys();
    void UpdateCtrlState();
    void ShowMessage(const std::string& sMessage, Gtk::MessageType nType = Gtk::MessageType::INFO);

protected:
    // A Gio::ListStore item.
    class CModelColumns : public Glib::Object {
    public:
        size_t m_nIdx;               // Позиция события в контроллере
        time_t m_tTime;              // Дата и время события
        ilg_event_type m_nType;      // Тип события
        ilg_event_format m_nFormat;  // Формат записи события
        ilg_direction m_nDirection;  // Направление
        Glib::Property<MyKeyNumber> m_property_number;
        uint8_t m_nModeFlags;         // Флаги режима
        uint8_t m_nModeTrigger;       // Триггер режима
        ilg_controller_mode m_nMode;  // Режим контроллера
        bool m_fKeyInitialized;       // true,
        uint8_t m_nKeyBankN;          // Номер банка ключей
        ssize_t m_nKeyIdx;            // Позиция в банке ключей

        static Glib::RefPtr<CModelColumns> create(size_t nIdx, const time_t& tTime,
                                                  ilg_event_type nType, ilg_event_format nFormat,
                                                  ilg_direction nDirection, bool fKeyInitialized,
                                                  bool fKeyEmpty, const ilg_key_number& rKeyNumber,
                                                  uint8_t nKeyFlags, uint8_t nModeFlags,
                                                  uint8_t nModeTrigger, ilg_controller_mode nMode,
                                                  uint8_t nKeyBankN, ssize_t nKeyIdx) {
            return Glib::make_refptr_for_instance<CModelColumns>(new CModelColumns(
                nIdx, tTime, nType, nFormat, nDirection, fKeyInitialized, fKeyEmpty, rKeyNumber,
                nKeyFlags, nModeFlags, nModeTrigger, nMode, nKeyBankN, nKeyIdx));
        }

    protected:
        CModelColumns(size_t nIdx, const time_t& tTime, ilg_event_type nType,
                      ilg_event_format nFormat, ilg_direction nDirection, bool fKeyInitialized,
                      bool fKeyEmpty, const ilg_key_number& rKeyNumber, uint8_t nKeyFlags,
                      uint8_t nModeFlags, uint8_t nModeTrigger, ilg_controller_mode nMode,
                      uint8_t nKeyBankN, ssize_t nKeyIdx) :
            Glib::ObjectBase(typeid(CModelColumns)),
            Glib::Object(),
            m_nIdx(nIdx),
            m_tTime(tTime),
            m_nType(nType),
            m_nFormat(nFormat),
            m_nDirection(nDirection),
            m_property_number(*this, "number",
                              fKeyEmpty ? MyKeyNumber() : MyKeyNumber(rKeyNumber, nKeyFlags)),
            m_nModeFlags(nModeFlags),
            m_nModeTrigger(nModeTrigger),
            m_nMode(nMode),
            m_fKeyInitialized(fKeyInitialized),
            m_nKeyBankN(nKeyBankN),
            m_nKeyIdx(nKeyIdx) {
        }
    };  // CModelColumns

    enum mode {
        MODE_UNDEF,
        MODE_READ_EVENTS,
        MODE_READ_KEYS
    };

    ilg::CController m_oController;  // Контроллер
    bool m_fWiegand;
    bool m_fX2;
    size_t m_nMaxEvents;
    size_t m_nMaxKeys;
    ssize_t m_nEventWriteIdx;  // Указатель записи событий
    ssize_t m_nEventReadIdx;   // Указатель чтения событий
    ilg::CAsyncCommand m_oCommand;
    mode m_nMode;
    uint8_t m_nReadBankIdx;
    size_t m_nReadIdx;
    size_t m_nReadCount;

    Gtk::Box m_VBox;  // Основная панель
    Gtk::ScrolledWindow m_ScrolledWindow;
    Gtk::ColumnView m_ColumnView;  // Таблица
    Glib::RefPtr<Gio::ListStore<CModelColumns>> m_ListStore;
    Glib::RefPtr<Gtk::CssProvider> m_refCssProvider;
    Gtk::Box m_BottomBox;          // Нижняя панель с кнопками
    Gtk::Button m_ReadAllButton;   // Кнопка "Читать все"
    Gtk::Button m_ReadNewButton;   // Кнопка "Читать новые"
    Gtk::Button m_ReadIdxButton;   // Кнопка "Указатель чтения"
    Gtk::Button m_WriteIdxButton;  // Кнопка "Указатель Записи"
    Glib::RefPtr<CProgressDialog> m_refProgressDialog;
    Glib::RefPtr<Gtk::MessageDialog> m_refDialog;
    Glib::Dispatcher m_oDisp;
};
