#pragma once
#include <stdint.h>

#include <string>
#include <vector>

#include "ilguard/ilguard.h"

// Название режимов считывателя
extern const char* kReaderMode[2];
// Названия режимов контроллера
extern const char* kControllerModeNames[ILG_CONTROLLER_MODE_SIZE];
// Названия типов точек прохода
extern const char* kPassPointTypeNames[ILG_PASS_POINT_SIZE];
// Названия типов событий контроллера
extern const char* kEventTypeNames[ILG_EVENT_TYPE_SIZE];
// Названия направлений прохода
extern const char* kDirectionNames[ILG_DIRECTION_SIZE];

std::vector<uint8_t> decodeHex(const std::string& source);
void replaceAll(std::string& str, const std::string& from, const std::string& to);
// Возвращает true если указанный год - високосный
bool IsLeapYear(uint nYear);