#pragma once
#include <gtkmm.h>

#include "ilguard/ilg_cpp_helpers.h"
#include "ilguard/ilguard.h"

/**
 * Окно "Режим Охрана" для настройки охранного режима
 */
class CSecurityDialog : public Gtk::Window {
public:
    CSecurityDialog();
    ~CSecurityDialog() override;

    void Init(const ilg::CController& oController);

protected:
    void on_button_read();
    void on_button_write();

    void DoRead();
    void DoWrite();
    void UpdateCtrlData(bool fSave);

protected:
    ilg::CController m_oController;  // Контроллер
    uint m_nSrcMask;
    int m_nTime;

    Gtk::Grid m_Grid;
    Gtk::CheckButton m_LoopsCheckButton;  // Флажок "Охранный шлейф"
    Gtk::CheckButton m_CoverCheckButton;  // Флажок "Снятие крышки контроллера"
    Gtk::CheckButton m_DoorCheckButton;  // Флажок "Контроль вскрытия двери"
    Gtk::Label m_TimeLabel;  // Метка "Время звучания сирены после исчезновения источника тревоги:"
    Glib::RefPtr<Gtk::Adjustment> m_refTimeAdjustment;
    Gtk::SpinButton m_TimeSpinButton;
    Gtk::Box m_ButtonsBox;
    Gtk::Button m_ReadButton;   // Кнопка "Читать"
    Gtk::Button m_WriteButton;  // Кнопка "Записать"
};
