#pragma once
#include <gtkmm.h>

#include "ilguard/ilg_cpp_helpers.h"
#include "ilguard/ilguard.h"

class CLockDialog : public Gtk::Window {
public:
    CLockDialog();
    ~CLockDialog() override;

    void Init(const ilg::CController& oController);

protected:
    void on_button_in2out();
    void on_button_out2in();
    void on_button_bigtime0();
    void on_button_bigtime1();
    void on_button_reset_times();
    void on_button_cancel();
    void on_button_ok();
    void on_dialog_response(int);

    void UpdateCtrlData(bool fSave);
    void ShowMessage(const std::string& sMessage, Gtk::MessageType nType = Gtk::MessageType::INFO);

protected:
    ilg::CController m_oController;  // Контроллер
    uint m_nBankCount;
    uint16_t m_aTimes[2][3];
    bool m_aBigTime[2] = {false};
    bool m_fApbEnabled;
    uint16_t m_nApbMinutes;
    bool m_fEmergencyMode;

    Gtk::Box m_VBox;          // Основная панель
    Gtk::Frame m_TimesFrame;  // Группа "Времена замка"
    Gtk::Grid m_TimesGrid;
    Gtk::Label m_InLabel;   // Метка "Вход"
    Gtk::Label m_OutLabel;  // Метка "Выход"
    Gtk::Label m_aTimeLabels[3];
    Gtk::Label m_BigTimeLabel;
    Gtk::Button m_In2OutButton;
    Gtk::Button m_Out2InButton;
    Glib::RefPtr<Gtk::Adjustment> m_refTimesAdjustment[2][3];
    Gtk::SpinButton m_aTimesSpinButtons[2][3];
    Gtk::CheckButton m_aBigTimeCheckButtons[2];
    Gtk::Button m_ResetTimesButton;
    Gtk::Frame m_ApbTimeFrame;  // Группа "Время антипассбэк"
    Gtk::Box m_ApbTimeBox;
    Gtk::CheckButton m_ApbCheckButton;  // Флажок "Включено"""
    Gtk::Box m_ApbBox;
    Gtk::Label m_ApbLabel;  // Метка "Время (минут):"
    Glib::RefPtr<Gtk::Adjustment> m_refApbAdjustment;
    Gtk::SpinButton m_ApbSpinButton;
    Gtk::CheckButton m_EmergencyCheckButton;  // Флажок "Аварийное открывание (старая команда)"
    Gtk::Box m_BottomBox;        // Нижняя панель с кнопками
    Gtk::Button m_CancelButton;  // Кнопка "Отмена"
    Gtk::Button m_OkButton;      // Кнопка "OK"
    Glib::RefPtr<Gtk::MessageDialog> m_refDialog;
};
