#pragma once
#include <gtkmm.h>

#include "ilguard/ilg_cpp_helpers.h"
#include "ilguard/ilguard.h"
#include "types.h"

class CKeyDialog : public Gtk::Window {
public:
    CKeyDialog();
    ~CKeyDialog() override;

    void Init(bool fOut, size_t nIdx, uint32_t nCtrFlags);

protected:
    void on_button_cancel();
    void on_button_ok();
    void on_button_type_clicked(int nType);
    void on_button_access_clicked(int n);
    void on_destroy();
    void on_dialog_response(int);
    void on_dropdown_format_selected_changed();
    void on_dropdown_format2_selected_changed();
    void on_button_dual_toggled();

    void InitScheduleListBox();
    void UpdateCtrlData(bool fSave);
    void UpdateKeyNumData(bool fSave);
    void UpdateAccessCtrlState();
    bool TryStrToKeyNum(const std::string& s, ilg_key_number& rNumber, int nDualIdx = -1);
    void ShowMessage(const std::string& sMessage, Gtk::MessageType nType = Gtk::MessageType::INFO);

public:
    bool m_fOut;
    size_t m_nIdx;
    uint32_t m_nCtrFlags;
    ilg_key m_rKey;
    ilg_time_zone m_aTzs[2][7];
    bool m_fAccept;

protected:
    class CMyListRow : public Gtk::ListBoxRow {
    public:
        CMyListRow() {
            set_child(m_Box);
            set_halign(Gtk::Align::START);
            m_Box.set_spacing(5);
            m_Box.append(m_CheckButton);
            m_Box.append(m_Label);
            m_Label.set_size_request(150);
        }

        void set_active(bool fActive) {
            m_CheckButton.set_active(fActive);
        }

        bool get_active() const {
            return m_CheckButton.get_active();
        }

        void set_text(const std::string& text) {
            m_Label.set_label(text);
        }

    protected:
        Gtk::Box m_Box;
        Gtk::CheckButton m_CheckButton;
        Gtk::Label m_Label;
    };

    edit_key_format m_nEditFormat;
    edit_key_format m_nEditFormat2;
    int m_nErrorEditIdx;
    uint32_t m_nSaveAccess;

    Gtk::Grid m_Grid;
    Gtk::Frame m_NumberFrame;  // Группа "Номер ключа"
    Gtk::Grid m_NumberGrid;
    Gtk::Entry m_NumberEntry;  // Поле ввода "Номер ключа"
    Glib::RefPtr<Gtk::StringList> m_refFormatStringList;
    Gtk::DropDown m_FormatDropDown;   // Выпадающий список "Формат"
    Gtk::Entry m_Number2Entry;        // Поле ввода "Номер ключа 2"
    Gtk::DropDown m_Format2DropDown;  // Выпадающий список "Формат 2"
    Gtk::Box m_FlagsBox;
    Gtk::CheckButton m_ShortCheckButton;  // Флажок "Короткий номер"
    Gtk::CheckButton m_FuncCheckButton;   // Флажок "Функциональный"
    Gtk::CheckButton m_DualCheckButton;   // Флажок "Двойной"
    Gtk::Frame m_TypeFrame;               // Группа "Тип"
    Gtk::Box m_TypeBox;
    Gtk::CheckButton m_TypeRadioButtons[3];  // Переключатели "Простой", "Блокирующий", "Мастер"
    Gtk::Frame m_AccessFrame;  // Группа "Доступ"
    Gtk::Box m_AccessBox;
    Gtk::CheckButton m_EverCheckButton;      // Переключатель "Всегда"
    Gtk::CheckButton m_NeverCheckButton;     // Переключатель "Никогда"
    Gtk::CheckButton m_ScheduleCheckButton;  // Переключатель "По расписанию"
    Glib::RefPtr<Gtk::CssProvider> m_refCssProvider;
    Gtk::ListBox m_TzListBox;  // Список "Расписание"
    CMyListRow m_aTzRows[7];
    Gtk::Box m_BottomBox;        // Нижняя панель с кнопками
    Gtk::Button m_CancelButton;  // Кнопка "Отмена"
    Gtk::Button m_OkButton;      // Кнопка "OK"
    Glib::RefPtr<Gtk::MessageDialog> m_refDialog;
};
