#include "CFireDialog.h"

CFireDialog::CFireDialog() :
    m_nSrcMask(0),
    m_nLimitT(0),
    m_ExternalCheckButton("Внешний сигнал"),
    m_TempCheckButton("Температурный датчик"),
    m_LimitLabel("Пороговая температура:"),
    m_refLimitAdjustment(Gtk::Adjustment::create(0, 0, 255.0)),
    m_ButtonsBox(Gtk::Orientation::VERTICAL),
    m_ReadButton("Читать"),
    m_WriteButton("Записать") {
    set_destroy_with_parent(true);
    set_title("Режим Пожар");
    set_default_size(350, 120);

    set_child(m_Grid);

    m_Grid.set_margin(5);
    m_Grid.set_row_spacing(10);
    m_Grid.set_column_spacing(10);
    m_Grid.attach(m_ExternalCheckButton, 0, 0, 2);
    m_Grid.attach(m_ButtonsBox, 2, 0, 1, 3);
    m_Grid.attach(m_TempCheckButton, 0, 1, 2);
    m_Grid.attach(m_LimitLabel, 0, 2);
    m_Grid.attach(m_LimitSpinButton, 1, 2);

    m_LimitSpinButton.set_adjustment(m_refLimitAdjustment);

    m_ButtonsBox.set_margin(5);
    m_ButtonsBox.set_spacing(5);
    m_ButtonsBox.append(m_ReadButton);
    m_ButtonsBox.append(m_WriteButton);

    m_ReadButton.signal_clicked().connect(sigc::mem_fun(*this, &CFireDialog::on_button_read));
    m_WriteButton.signal_clicked().connect(sigc::mem_fun(*this, &CFireDialog::on_button_write));
}

CFireDialog::~CFireDialog() {
}

void CFireDialog::Init(const ilg::CController& oController) {
    m_oController = oController.Clone();
    DoRead();
}

void CFireDialog::on_button_read() {
    DoRead();
}

void CFireDialog::on_button_write() {
    DoWrite();
}

void CFireDialog::DoRead() {
    uint8_t nSrcMask, nLimitT, nState, nT;
    m_oController.ReadFireParams(nSrcMask, nLimitT, nState, nT);
    m_nSrcMask = nSrcMask;
    m_nLimitT = nLimitT;
    UpdateCtrlData(false);
}

void CFireDialog::DoWrite() {
    UpdateCtrlData(true);
    m_oController.WriteFireParams(static_cast<uint8_t>(m_nSrcMask),
                                  static_cast<uint8_t>(m_nLimitT));
}

void CFireDialog::UpdateCtrlData(bool fSave) {
    if (fSave) {
        SET_BIT(m_nSrcMask, 0, m_ExternalCheckButton.get_active());
        SET_BIT(m_nSrcMask, 1, m_TempCheckButton.get_active());
        m_nLimitT = m_LimitSpinButton.get_value_as_int();
    }
    else {
        m_ExternalCheckButton.set_active(GET_BIT(m_nSrcMask, 0));
        m_TempCheckButton.set_active(GET_BIT(m_nSrcMask, 1));
        m_LimitSpinButton.set_value(m_nLimitT);
    }
}
