#pragma once

#include <filesystem>

#include "ilguard/ilguard.h"
#include "types.h"

class CAppSetings {
protected:
    bool m_fModified;

public:
    bool m_fDebugLog;
    bool m_fClearLogAtStartup;
    ilg_log_level m_nLogLevel;
    uint32_t m_nConverterTypes;
    bool m_fShowUnidentified;
    // Выбор формата в окне "Key properties"
    edit_key_format m_nEditFormat;
    edit_key_format m_nEditFormat2;

protected:
    std::filesystem::path GetFilePath() const;

public:
    CAppSetings();
    ~CAppSetings();

    void Load();
    void Save();

    bool IsModified() const {
        return m_fModified;
    }

    void SetDebugLog(bool fValue);
    void SetClearLogAtStartup(bool fValue);
    void SetLogLevel(ilg_log_level nValue);
    void SetConverterType(ilg_converter_types nType, bool fSet);
    void SetShowUnidentified(bool fValue);
    void SetEditFormat(edit_key_format nValue);
    void SetEditFormat2(edit_key_format nValue);
};

extern CAppSetings g_AppSet;
