#include "CAppSettings.h"

#include <limits.h>
#include <unistd.h>

#include <fstream>

CAppSetings g_AppSet;

CAppSetings::CAppSetings() :
    m_fModified(false),
    m_fDebugLog(false),
    m_fClearLogAtStartup(true),
    m_nLogLevel(ILG_LOG_LEVEL_DEBUG),
    m_nConverterTypes(ILG_CONVERTER_ILUSB | ILG_CONVERTER_CLIENT | ILG_CONVERTER_SERVER),
    m_fShowUnidentified(true),
    m_nEditFormat(EDIT_KEY_FORMAT_DALLAS),
    m_nEditFormat2(EDIT_KEY_FORMAT_KEYPAD) {
}

CAppSetings::~CAppSetings() {
}

std::filesystem::path CAppSetings::GetFilePath() const {
    char szCfgPath[PATH_MAX];
    auto count = readlink("/proc/self/exe", szCfgPath, std::size(szCfgPath) - 1);
    szCfgPath[count] = '\0';
    std::stringstream ss;
    ss << szCfgPath << ".settings.txt";
    return ss.str();
}

void CAppSetings::Load() {
    auto sPath(GetFilePath());
    if (std::filesystem::exists(sPath)) {
        std::ifstream inFile;
        inFile.open(sPath);
        uint n = (uint)m_nLogLevel;
        inFile >> std::dec >> n;
        if (n < ILG_LOG_LEVEL_SIZE)
            m_nLogLevel = (ilg_log_level)n;
        inFile >> std::boolalpha >> m_fDebugLog >> m_fClearLogAtStartup;
        inFile >> std::hex >> m_nConverterTypes >> m_fShowUnidentified;
        n = (uint)m_nEditFormat;
        inFile >> n;
        if (n < EDIT_KEY_FORMAT_SIZE)
            m_nEditFormat = (edit_key_format)n;
        n = (uint)m_nEditFormat2;
        inFile >> n;
        if (n < EDIT_KEY_FORMAT_SIZE)
            m_nEditFormat2 = (edit_key_format)n;
    }
}

void CAppSetings::Save() {
    m_fModified = false;
    std::filesystem::path sPath(GetFilePath());
    std::ofstream outFile;
    outFile.open(sPath);
    outFile.imbue(std::locale("C"));
    outFile << std::dec << (uint)m_nLogLevel << '\t' << std::boolalpha << m_fDebugLog << '\t'
            << m_fClearLogAtStartup << std::endl
            << std::hex << std::showbase << m_nConverterTypes << '\t' << m_fShowUnidentified
            << std::endl
            << (uint)m_nEditFormat << std::endl
            << (uint)m_nEditFormat2;
}

void CAppSetings::SetDebugLog(bool fValue) {
    if (m_fDebugLog == fValue)
        return;
    m_fDebugLog = fValue;
    m_fModified = true;
}

void CAppSetings::SetClearLogAtStartup(bool fValue) {
    if (m_fClearLogAtStartup == fValue)
        return;
    m_fClearLogAtStartup = fValue;
    m_fModified = true;
}

void CAppSetings::SetLogLevel(ilg_log_level nValue) {
    if (m_nLogLevel == nValue)
        return;
    m_nLogLevel = nValue;
    m_fModified = true;
}

void CAppSetings::SetConverterType(ilg_converter_types nType, bool fSet) {
    bool f = (m_nConverterTypes & nType) != 0;
    if (f == fSet)
        return;
    if (fSet)
        m_nConverterTypes |= nType;
    else
        m_nConverterTypes &= ~nType;
    m_fModified = true;
}

void CAppSetings::SetShowUnidentified(bool fValue) {
    if (m_fShowUnidentified == fValue)
        return;
    m_fShowUnidentified = fValue;
    m_fModified = true;
}

void CAppSetings::SetEditFormat(edit_key_format nValue) {
    if (m_nEditFormat == nValue)
        return;
    m_nEditFormat = nValue;
    m_fModified = true;
}

void CAppSetings::SetEditFormat2(edit_key_format nValue) {
    if (m_nEditFormat2 == nValue)
        return;
    m_nEditFormat2 = nValue;
    m_fModified = true;
}
