#pragma once
#include <filesystem>
#include <string>

#include "ilreaders/ilreaders.h"
#include "types.h"

// Возвращает путь к директории программы
std::filesystem::path GetAppDir();
// Преобразует пароль Temic в строку
std::string TemicPasswordToString(const int64_t& nPassword);
// Пытается преобразовать строку в пароль Temic
bool TryParseTemicPassword(const char* pStr, int64_t& nPassword);
// Ищет пароль в списке паролей Temic
ssize_t FindTemicPassword(const CTemicPasswordList& oPasswords, uint nPassword);
// Возвращает путь к файлу списка паролей Temic
std::filesystem::path GetTemicPasswordsFilePath();

// Возвращает путь к файлу списка ключей Mifare Classic
std::filesystem::path GetMcKeysFilePath();
// Ищет ключ в списке ключей Mifare Classic
ssize_t FindMcKey(const CMcKeyList& oKeys, const int64_t& nKey);
// Возвращает путь к файлу списка ключей Mifare Plus
std::filesystem::path GetMpKeysFilePath();
// // Загружает список ключей Mifare Plus из файла
// void LoadMpKeysFromFile(const std::filesystem::path& path, CMpKeyList& oKeys);
// // Сохраняет список ключей Mifare Plus в файл
// void SaveMpKeysToFile(const std::filesystem::path& path, const CMpKeyList& oKeys);
// Ищет ключ в списке ключей Mifare Plus
ssize_t FindMpKey(const CMpKeyList& oKeys, const ilr_mf_plus_key& Key);

// True, разрешена запись ключа А в трейлер-блок Mifare Classic/Plus
bool CanMfWriteKeyA(uint nTrailerAreaAccess, bool fAuthKeyB);

// True, разрешено чтение битов доступа из трейлер-блока Mifare Classic/Plus
// bool CanMfReadAccessBits(uint nTrailerAreaAccess, bool fAuthKeyB);

// True, разрешена запись битов доступа в трейлер-блок Mifare Classic/Plus
bool CanMfWriteAccessBits(uint nTrailerAreaAccess, bool fAuthKeyB);

// True, разрешено чтение ключа Б из трейлер-блока Mifare Classic/Plus
bool CanMfReadKeyB(uint nTrailerAreaAccess, bool fAuthKeyB);

// True, разрешена запись ключа Б в трейлер-блок Mifare Classic/Plus
bool CanMfWriteKeyB(uint nTrailerAreaAccess, bool fAuthKeyB);

// True, разрешено чтение данных из блока пользовательских данных Mifare Classic/Plus
bool CanMfReadUserData(uint nUserDataAreaAccess, bool fAuthKeyB);

// True, разрешена запись данных в блок пользовательских данных Mifare Classic/Plus
bool CanMfWriteUserData(uint nUserDataAreaAccess, bool fAuthKeyB);

// True, разрешен инкремент блока-значения Mifare Classic/Plus
bool CanMfIncrementUserData(uint nUserDataAreaAccess, bool fAuthKeyB);

// True, разрешены декремент, transfer, restore блока-значения Mifare Classic/Plus
bool CanMfDtrUserData(uint nUserDataAreaAccess, bool fAuthKeyB);

extern const char* kNoAccessStr;
extern const char* kKeyAAccessStr;
extern const char* kKeyBAccessStr;
extern const char* kKeyAorBAccessStr;
