#include "CTemicReaderSettings.h"

#include <fstream>

CTemicReaderSettings::CTemicReaderSettings() :
    m_fModified(false),
    m_fTemicAutoScan(false),
    m_nTemicScanParam(-1),
    m_fTemicPswEnabled(false),
    m_nTemicPassword(0) {
}

void CTemicReaderSettings::Load(const std::filesystem::path& path) {
    m_fModified = false;
    if (std::filesystem::exists(path)) {
        std::ifstream inFile;
        inFile.open(path);
        inFile >> std::boolalpha >> m_fTemicAutoScan >> std::dec >> m_nTemicScanParam >>
            m_fTemicPswEnabled >> std::hex >> m_nTemicPassword;
    }
}

void CTemicReaderSettings::Save(const std::filesystem::path& path) {
    std::ofstream outFile;
    outFile.open(path);
    outFile.imbue(std::locale("C"));
    outFile << std::showbase << std::boolalpha << m_fTemicAutoScan << '\t' << std::dec
            << m_nTemicScanParam << std::endl
            << m_fTemicPswEnabled << '\t' << std::hex << m_nTemicPassword << std::endl;
    m_fModified = false;
}

void CTemicReaderSettings::SetTemicPswEnabled(bool fEnabled) {
    if (m_fTemicPswEnabled == fEnabled)
        return;
    m_fTemicPswEnabled = fEnabled;
    m_fModified = true;
}

void CTemicReaderSettings::SetTemicPassword(uint nPassword) {
    if (m_nTemicPassword == nPassword)
        return;
    m_nTemicPassword = nPassword;
    m_fModified = true;
}

void CTemicReaderSettings::SetTemicScanParam(int nValue) {
    if (m_nTemicScanParam == nValue)
        return;
    m_nTemicScanParam = nValue;
    m_fModified = true;
}
