#pragma once
#include <gtkmm.h>

#include "CCardDataGrid.h"
#include "CTemicPasswordsDialog.h"
#include "CTemicPasswordsSettings.h"
#include "ilreaders/ilr_cpp_helpers.h"
#include "ilreaders/ilreaders.h"
#include "types.h"

class CTemicDialog : public Gtk::Window {
public:
    CTemicDialog();
    ~CTemicDialog() override;

    void Init(const ilr::CReader& oReader, Glib::RefPtr<CTemicPasswordsSettings> refSettings);

protected:
    uint on_data_get_byte_access(uint nAddress);
    void on_data_validate_byte(uint nAddress, uint8_t& b);
    void on_data_checkbox_toggle(uint nBlockIdx);
    void on_serial_color_set();
    void on_password_color_set();
    void on_user_data_color_set();
    void on_config_color_set();
    void on_hex_toggled();
    void on_dec_toggled();
    void on_oct_toggled();
    void on_bin_toggled();
    void on_button_toggle_password();
    void on_password_selected_changed();
    void on_button_edit_passwords();
    void on_passwords_dialog_hide();
    void on_mode_selected_changed();
    void on_bitrate_selected_changed();
    void on_modulation_selected_changed();
    void on_pskcf_selected_changed();
    void on_maxblock_selected_changed();
    void on_test_mode_toggle();
    void on_aor_mode_toggle();
    void on_st_toggle();
    void on_sst_toggle();
    void on_por_delay_toggle();
    void on_otp_toggle();
    void on_fast_write_toggle();
    void on_inverse_data_toggle();
    void on_emulation_switch_page(Widget* page, guint page_number);
    void on_em_marine_toggled();
    void on_hid_toggled();
    void on_hid_wiegand_value_changed();
    void on_button_emu_get();
    void on_button_emu_set();
    void on_button_read();
    void on_button_write();
    void on_confirm_lock_temic_dialog_response(int response_id);
    void on_dialog_response(int);
    void on_hide();

    void ReadCardData();
    void WriteCardData();
    void SetByte(int nBlockIdx, int nByteIdx, uint8_t nValue, bool fUpdateGrid = true);
    bool GetXMode() const;
    void UpdateConfigGroupData(bool fSave);
    void UpdatePasswordGroupCtrlState();
    void UpdatePasswordDropDown();
    void UpdateDataGridPasswordColor();
    void UpdateBitRateDropDown();
    void UpdateModulationDropDown();
    void UpdateEmulatedLabel();
    void UpdateNewCardTypeCtrl();
    void UpdateNewEmMarineCtrlData(bool fSave);
    void UpdateNewHidCtrlData(bool fSave);
    void MessageDialog(const std::string& sMessage, Gtk::MessageType nType = Gtk::MessageType::INFO,
                       Gtk::ButtonsType nButtons = Gtk::ButtonsType::OK,
                       Gio::ActionMap::ActivateWithIntParameterSlot&& slot =
                           Gio::ActionMap::ActivateWithIntParameterSlot());

public:
    static constexpr uint s_aE5550BitRates[8] = {8U, 16U, 32U, 40U, 50U, 64U, 100U, 128U};
    static const char* kModulationNames[32];
    static constexpr uint kXModeModulations = 0x0101013F;
    static constexpr uint kE5550Modulations = 0x010101FF;

protected:
    ilr::CReader m_oReader;  // Считыватель
    Glib::RefPtr<CTemicPasswordsSettings> m_refTmcPasswords;
    ilr_card_uid m_rTemicUid;
    uint8_t m_aOldBlocks[10][4];  // Исходные данные карты (10 страниц по 4 байта)
    uint8_t m_aNewBlocks[10][4];  // Изменённые данные карты
    int64_t m_nActivePassword;    // Текущий пароль Temic
    uint32_t m_nLocks;  // Биты блокировки блоков карты от перезаписи
    bool m_fLockUpdate;  // True, заблокировать обработку событий
    // Настройки новой эмулируемой карты
    ilr_card_type m_nNewCardType;  // Тип новой эмулируемой карты
    ilr::CCardUID m_rNewEmMarineUid;  // Номер Em-Marine для новой эмулируемой карты
    ilr::CCardUID m_rNewHidUid;  // Номер HID для новой эмулируемой карты
    int m_nNewHidWiegand;        // Номер кодировки Виганд
    bool m_fEntryEmFacilityValid;
    bool m_fEntryHidFacilityValid;

    Gtk::Box m_VBox;
    Gtk::Box m_DataBox;
    Gtk::ScrolledWindow m_DataScrolledWindow;
    CCardDataGrid m_DataGrid;
    Gtk::Box m_RightBox;
    Gtk::Frame m_LegendFrame;  // Группа "Легенда"
    Gtk::Grid m_LegendGrid;
    Gtk::ColorButton m_SerialButton;    // Кнопка "Серийный номер"
    Gtk::Label m_SerialLabel;           // Метка "Серийный номер"
    Gtk::ColorButton m_PasswordButton;  // Кнопка "Пароль"
    Gtk::Label m_PasswordLabel;         // Метка "Пароль"
    Gtk::ColorButton m_UserDataButton;  // Кнопка "Данные пользователя"
    Gtk::Label m_UserDataLabel;         // Метка "Данные пользователя"
    Gtk::ColorButton m_ConfigButton;    // Кнопка "Конфигурация"
    Gtk::Label m_ConfigLabel;           // Метка "Конфигурация"
    Gtk::Frame m_FormatFrame;           // Группа "Формат данных"
    Gtk::Box m_FormatBox;
    Gtk::CheckButton m_HexCheckButton;  // Переключатель "Шестнадцатеричный"
    Gtk::CheckButton m_DecCheckButton;  // Переключатель "Десятичный"
    Gtk::CheckButton m_OctCheckButton;  // Переключатель "Восьмеричный"
    Gtk::CheckButton m_BinCheckButton;  // Переключатель "Двоичный"
    Gtk::Frame m_PasswordFrame;         // Группа "Пароль"
    Gtk::Box m_PasswordBox;
    Gtk::CheckButton m_PasswordCheckButton;  // Флажок "Пароль"
    Gtk::DropDown m_PasswordDropDown;
    Glib::RefPtr<Gtk::StringList> m_refPasswordStringList;
    Gtk::Button m_PasswordEditButton;  // Кнопка "..." для изменения списка паролей Temic
    Gtk::Frame m_ConfigFrame;  // Группа "Конфигурация"
    Gtk::Grid m_ConfigGrid;
    Gtk::Label m_ModeLabel;  // Метка "Режим:"
    Glib::RefPtr<Gtk::StringList> m_refModeStringList;
    Gtk::DropDown m_ModeDropDown;
    Gtk::Label m_BitRateLabel;  // Метка "Data Bit Rate:"
    Gtk::DropDown m_BitRateDropDown;
    Glib::RefPtr<Gtk::StringList> m_refBitRateStringList;
    Gtk::Label m_ModulationLabel;  // Метка "Modulation:"
    Gtk::DropDown m_ModulationDropDown;
    Glib::RefPtr<Gtk::StringList> m_refModulationStringList;
    Gtk::Label m_PskCfLabel;  // Метка "PSK-CF:"
    Gtk::DropDown m_PskCfDropDown;
    Glib::RefPtr<Gtk::StringList> m_refPskCfStringList;
    Gtk::Label m_MaxBlockLabel;  // Метка "Max Block:"
    Gtk::DropDown m_MaxBlockDropDown;
    Glib::RefPtr<Gtk::StringList> m_refMaxBlockStringList;
    Gtk::Box m_ConfigFlagsBox;
    Gtk::CheckButton m_TestModeCheckButton;     // Флажок "Test mode"
    Gtk::CheckButton m_AorModeCheckButton;      // Флажок "Answer-On-Request (AOR) Mode"
    Gtk::CheckButton m_StCheckButton;           // Флажок "ST-sequence Terminator"
    Gtk::CheckButton m_SstCheckButton;          // Флажок "SST-Sequence StartMarker"
    Gtk::CheckButton m_PorDelayCheckButton;     // Флажок "POR delay"
    Gtk::CheckButton m_OtpCheckButton;          // Флажок "OTP"
    Gtk::CheckButton m_FastWriteCheckButton;    // Флажок "Fast write"
    Gtk::CheckButton m_InverseDataCheckButton;  // Флажок "Inverse data"
    Gtk::Frame m_EmulationFrame;                // Группа "Эмуляция"
    Gtk::Box m_EmulationBox;
    Gtk::Frame m_CurrentEmuFrame;  // Группа "Текущая"
    Gtk::Label m_CurrentEmuLabel;  // Метка с текущей эмулируемой картой
    Gtk::Frame m_NewEmuFrame;      // Группа "Новая"
    Gtk::Box m_NewEmuBox;
    Gtk::Notebook m_EmulationNotebook;
    Gtk::CheckButton m_EmMarineCheckButton;
    Gtk::CheckButton m_HidCheckButton;
    Gtk::Grid m_EmMarineGrid;
    Gtk::Label m_EmFacilityLabel;  // Метка "Код производителя"
    Gtk::Entry m_EmFacilityEntry;
    Gtk::Label m_EmSeriesLabel;  // Метка "Серия"
    Glib::RefPtr<Gtk::Adjustment> m_refEmSeriesAdjustment;
    Gtk::SpinButton m_EmSeriesSpinButton;
    Gtk::Label m_EmNumberLabel;  // Метка "Номер"
    Glib::RefPtr<Gtk::Adjustment> m_refEmNumberAdjustment;
    Gtk::SpinButton m_EmNumberSpinButton;
    Gtk::Grid m_HidGrid;
    Gtk::Label m_HidWiegandLabel;  // Метка "Виганд"
    Glib::RefPtr<Gtk::Adjustment> m_refHidWiegandAdjustment;
    Gtk::SpinButton m_HidWiegandSpinButton;
    Gtk::Label m_HidFacilityLabel;  // Метка "Код производителя"
    Gtk::Entry m_HidFacilityEntry;
    Gtk::Label m_HidNumberLabel;  // Метка "Номер"
    Glib::RefPtr<Gtk::Adjustment> m_refHidNumberAdjustment;
    Gtk::SpinButton m_HidNumberSpinButton;
    Gtk::Box m_EmuButtonsBox;
    Gtk::Button m_EmuGetButton;  // Кнопка "Получить эмулируемый"
    Gtk::Button m_EmuSetButton;  // Кнопка "Применить"

    Gtk::Box m_BottomBox;       // Нижняя панель с кнопками
    Gtk::Button m_ReadButton;   // Кнопка "Читать"
    Gtk::Button m_WriteButton;  // Кнопка "Записать"
    Glib::RefPtr<Gtk::MessageDialog> m_refDialog;
    Glib::RefPtr<CTemicPasswordsDialog> m_refPasswordsDialog;  // Окно "Пароли Temic"
};
