#pragma once
#include <gtkmm.h>

#include "CMifareReaderSettings.h"
#include "ilreaders/ilr_cpp_helpers.h"
#include "ilreaders/ilreaders.h"

class CReaderMpKeysDialog : public Gtk::Window {
public:
    CReaderMpKeysDialog();
    ~CReaderMpKeysDialog() override;

    void Init(const ilr::CReader& oReader, Glib::RefPtr<CMifareReaderSettings> refSettings);

protected:
    void on_setup_checkbutton(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_setup_key(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_setup_comment(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_bind_idx(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_bind_key(const Glib::RefPtr<Gtk::ListItem>& list_item);
    bool key_transform_to(const GValue* a, GValue* b);
    bool key_transform_from(const GValue* a, GValue* b);
    void on_key_label_editing_change(Gtk::ListItem* list_item);
    void on_bind_comment(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_comment_label_editing_change(Gtk::ListItem* list_item);
    void on_button_writeall();
    void on_button_cancel();
    void on_button_ok();
    void on_dialog_response(int);

    void UpdateView(bool fKeyB);
    void SaveViewData();
    bool DoWriteKeys(bool fForce = false);
    void ShowMessage(const std::string& sMessage, Gtk::MessageType nType = Gtk::MessageType::INFO);
    std::string KeyToString(const ilr_mf_plus_key& key) const;
    bool TryParseKey(const char* pStr, ilr_mf_plus_key& key) const;

protected:
    // A Gio::ListStore item.
    struct my_key {
        bool m_fValid;
        ilr::CMifarePlusKey m_key;

        my_key() :
            m_fValid(false) {
        }

        my_key(bool fValid, const ilr::CMifarePlusKey& key) :
            m_fValid(fValid),
            m_key(key) {
        }
    };

    class ModelColumns : public Glib::Object {
    public:
        Glib::Property<bool> m_property_check;
        int m_nIdx;
        Glib::Property<my_key> m_property_key;
        Glib::Property<Glib::ustring> m_property_comment;

        static Glib::RefPtr<ModelColumns> create(bool fCheck, int nIdx, const my_key& key,
                                                 const Glib::ustring& sComment) {
            return Glib::make_refptr_for_instance<ModelColumns>(
                new ModelColumns(fCheck, nIdx, key, sComment));
        }

    protected:
        ModelColumns(bool fCheck, int nIdx, const my_key& key, const Glib::ustring& sComment) :
            Glib::ObjectBase(typeid(ModelColumns)),
            m_property_check(*this, "check", fCheck),
            m_nIdx(nIdx),
            m_property_key(*this, "key", key),
            m_property_comment(*this, "comment", sComment) {
        }
    };  // ModelColumns

protected:
    ilr::CReader m_oReader;  // Считыватель
    Glib::RefPtr<CMifareReaderSettings> m_refSettings;
    bool m_fModifed;
    uint m_nChangedKeys;  // Маска изменённых ключей, которые нужно записать в считыватель

    Gtk::Box m_VBox;
    Gtk::Notebook m_Notebook;  // Вкладки

    Gtk::ScrolledWindow m_aScrolledWindow[2];
    Gtk::ColumnView m_aColumnView[2];
    Glib::RefPtr<Gio::ListStore<ModelColumns>> m_aListStore[2];
    Glib::RefPtr<Gtk::CssProvider> m_refCssProvider;

    Gtk::Box m_BottomBox;          // Нижняя панель с кнопками
    Gtk::Button m_WriteAllButton;  // Кнопка "Записать все"
    Gtk::Button m_CancelButton;    // Кнопка "Отмена"
    Gtk::Button m_OkButton;        // Кнопка "OK"

    Glib::RefPtr<Gtk::MessageDialog> m_refDialog;
};
