#include "CMifareClassicDialog.h"

#include <iostream>

#include "CAppSettings.h"
#include "utils.h"

#define HAS_STYLE_PROVIDER_ADD_PROVIDER_FOR_DISPLAY GTKMM_CHECK_VERSION(4, 9, 1)

CMifareClassicDialog::CMifareClassicDialog() :
    m_nSectorIdx(-1),
    m_fAuthKeyB(false),
    m_fAuthByRdKeys(false),
    m_fLockUpdate(false),
    m_VBox(Gtk::Orientation::VERTICAL),
    m_AuthFrame("Авторизация"),
    m_AuthKeyFrame("Ключ"),
    m_AuthKeyBox(Gtk::Orientation::VERTICAL),
    m_ExplicitKeyCheckButton("Явный ключ"),
    m_ReaderKeysCheckButton("Ключи считывателя"),
    m_AuthKeyTypeFrame("Тип ключа"),
    m_AuthKeyTypeBox(Gtk::Orientation::VERTICAL),
    m_KeyACheckButton("Ключ А"),
    m_KeyBCheckButton("Ключ Б"),
    m_ExplicitKeyButton("..."),
    m_ReaderKeysButton("..."),
    m_DataVBox(Gtk::Orientation::VERTICAL),
    m_DataRightBox(Gtk::Orientation::VERTICAL),
    m_DataLegendFrame("Легенда для данных"),
    m_SerialButton(Gdk::RGBA(0.65, 0.79, 0.94)),
    m_SerialLabel("Серийный номер"),
    m_UserDataButton(Gdk::RGBA(0.66, 0.94, 0.66)),
    m_UserDataLabel("Данные пользователя"),
    m_UserDataRoButton(Gdk::RGBA(0.74, 0.86, 0.74)),
    m_UserDataRoLabel("Данные (только чтение)"),
    m_ValueButton(Gdk::RGBA(0.61, 1.0, 1.0)),
    m_ValueLabel("Блок-значение"),
    m_ValueDtrButton(Gdk::RGBA(0.73, 0.86, 0.86)),
    m_ValueDtrLabel("Блок-значение (только Д/П/В)"),
    m_NrwDataButton(Gdk::RGBA(0.75, 0.75, 0.75)),
    m_NrwDataLabel("Данные (нельзя читать/писать)"),
    m_TrailerLegendFrame("Легенда для прицепа"),
    m_AccessBitsButton(Gdk::RGBA(1.0, 1.0, 0.60)),
    m_AccessBitsLabel("Биты доступа"),
    m_AccessBitsRoButton(Gdk::RGBA(0.87, 0.87, 0.74)),
    m_AccessBitsRoLabel("Биты доступа (только чтение)"),
    m_KeyButton(Gdk::RGBA(0.84, 0.60, 1.0)),
    m_KeyLabel("Ключ"),
    m_NrwKeyButton(Gdk::RGBA(0.75, 0.75, 0.75)),
    m_NrwKeyLabel("Ключ (нельзя читать/писать)"),
    m_FormatFrame("Формат данных"),
    m_FormatBox(Gtk::Orientation::VERTICAL),
    m_HexCheckButton("Шестнадцатеричный"),
    m_DecCheckButton("Десятичный"),
    m_OctCheckButton("Восьмеричный"),
    m_BinCheckButton("Двоичный"),
    m_SectorFrame("Конфигурация сектора"),
    m_SectorBox(Gtk::Orientation::VERTICAL),
    m_ValueBlockFrame("Блок-значение"),
    m_Value2Label("Значение:"),
    m_refValueAdjustment(Gtk::Adjustment::create(0, std::numeric_limits<int>::min(),
                                                 std::numeric_limits<int>::max())),
    m_ValueSpinButton(m_refValueAdjustment),
    m_AddressLabel("Адрес:"),
    m_refAddressAdjustment(Gtk::Adjustment::create(0, 0, 255)),
    m_AddressSpinButton(m_refAddressAdjustment),
    m_ValueDeltaLabel("Изменить на:"),
    m_refValueDeltaAdjustment(Gtk::Adjustment::create(0, 0, std::numeric_limits<uint32_t>::max())),
    m_ValueDeltaSpinButton(m_refValueDeltaAdjustment),
    m_IncrementButton("Увеличить"),
    m_DecrementButton("Уменьшить"),
    m_TransferButton("Передать"),
    m_RestoreButton("Восстановить"),
    m_SectorKeysFrame("Ключи авторизации"),
    m_SectorKeyALabel("Ключ А"),
    m_SectorKeyAButton("Ключи.."),
    m_SectorKeyBLabel("Ключ Б"),
    m_SectorKeyBButton("Ключи.."),
    m_SectorTrailerFrame("Доступ прицепа"),
    m_SectorUserDataFrame("Доступ к данным пользователя"),
    m_ReadButton("Читать"),
    m_WriteButton("Записать"),
    m_ErrorsButton("Сообщения об ошибках...") {
    set_destroy_with_parent(true);

    set_title("Mifare Classic");
    set_default_size(990, 970);

    set_child(m_VBox);
    m_VBox.set_margin(5);
    m_VBox.set_expand();
    m_VBox.append(m_AuthFrame);
    m_VBox.append(m_MiddleBox);
    m_VBox.append(m_BottomBox);

    m_AuthFrame.set_child(m_AuthBox);
    m_AuthBox.set_margin(5);
    m_AuthBox.append(m_AuthKeyFrame);
    m_AuthBox.append(m_AuthKeyTypeFrame);
    m_AuthBox.append(m_AuthKeysNotebook);

    m_AuthKeyFrame.set_child(m_AuthKeyBox);
    m_AuthKeyBox.set_margin(5);
    m_AuthKeyBox.append(m_ExplicitKeyCheckButton);
    m_AuthKeyBox.append(m_ReaderKeysCheckButton);
    m_ReaderKeysCheckButton.set_group(m_ExplicitKeyCheckButton);
    m_ExplicitKeyCheckButton.signal_toggled().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_explicit_key_toggled));
    m_ReaderKeysCheckButton.signal_toggled().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_reader_keys_toggled));

    m_AuthKeyTypeFrame.set_child(m_AuthKeyTypeBox);
    m_AuthKeyTypeBox.set_margin(5);
    m_AuthKeyTypeBox.append(m_KeyACheckButton);
    m_AuthKeyTypeBox.append(m_KeyBCheckButton);
    m_KeyBCheckButton.set_group(m_KeyACheckButton);

    m_AuthKeysNotebook.set_show_tabs(false);
    m_AuthKeysNotebook.append_page(m_ExplicitKeyBox);
    m_AuthKeysNotebook.append_page(m_ReaderKeysGrid);

    m_ExplicitKeyBox.set_margin(5);
    m_ExplicitKeyBox.append(m_ExplicitKeyEntry);
    m_ExplicitKeyBox.append(m_ExplicitKeyButton);
    m_ExplicitKeyEntry.set_valign(Gtk::Align::CENTER);
    m_ExplicitKeyButton.set_valign(Gtk::Align::CENTER);
    m_ExplicitKeyButton.signal_clicked().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_explicit_key_button_clicked));
    m_ReaderKeysGrid.set_margin(5);
    m_ReaderKeysGrid.set_column_spacing(5);
    m_ReaderKeysGrid.set_row_spacing(5);
    int nCol = 0;
    int nRow = 0;
    for (size_t i = 0; i < std::size(m_aReaderKeyCheckButtons); i++) {
        m_aReaderKeyCheckButtons[i].set_label(Glib::ustring::format(i));
        m_ReaderKeysGrid.attach(m_aReaderKeyCheckButtons[i], nCol, nRow);
        if (++nCol == 8) {
            nCol = 0;
            ++nRow;
        }
    }
    m_ReaderKeysGrid.attach(m_ReaderKeysButton, 8, 0, 1, 2);
    m_ReaderKeysButton.set_valign(Gtk::Align::CENTER);
    m_ReaderKeysButton.signal_clicked().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_reader_keys_button_clicked));

    m_MiddleBox.append(m_GroupScrolledWindow);
    m_MiddleBox.append(m_DataVBox);

    m_DataVBox.append(m_DataHBox);
    m_DataVBox.append(m_SectorFrame);
    m_DataHBox.append(m_DataScrolledWindow);
    m_DataHBox.append(m_DataRightScrolledWindow);

    m_DataRightScrolledWindow.set_policy(Gtk::PolicyType::NEVER, Gtk::PolicyType::AUTOMATIC);
    m_DataRightScrolledWindow.set_vexpand();
    m_DataRightScrolledWindow.set_child(m_DataRightBox);

    m_DataRightBox.set_spacing(5);
    m_DataRightBox.append(m_DataLegendFrame);
    m_DataRightBox.append(m_TrailerLegendFrame);
    m_DataRightBox.append(m_FormatFrame);

    m_GroupScrolledWindow.set_policy(Gtk::PolicyType::NEVER, Gtk::PolicyType::AUTOMATIC);
    m_GroupScrolledWindow.set_vexpand();
    m_GroupScrolledWindow.set_child(m_GroupListBox);

    m_GroupListBox.signal_selected_rows_changed().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_group_selected_row_changed));

    m_DataScrolledWindow.set_policy(Gtk::PolicyType::AUTOMATIC, Gtk::PolicyType::AUTOMATIC);
    m_DataScrolledWindow.set_expand();
    m_DataScrolledWindow.set_child(m_CardDataGrid);

    m_SerialButton.set_rgba(g_AppSet.m_McSerialColor);
    m_SerialButton.signal_color_set().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_serial_color_set));
    m_UserDataButton.set_rgba(g_AppSet.m_McUserDataColor);
    m_UserDataButton.signal_color_set().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_user_data_color_set));
    m_UserDataRoButton.set_rgba(g_AppSet.m_McUserDataRoColor);
    m_UserDataButton.signal_color_set().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_user_data_ro_color_set));
    m_ValueButton.set_rgba(g_AppSet.m_McValueColor);
    m_ValueButton.signal_color_set().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_value_color_set));
    m_ValueDtrButton.set_rgba(g_AppSet.m_McValueDtrColor);
    m_ValueDtrButton.signal_color_set().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_value_dtr_color_set));
    m_NrwDataButton.set_rgba(g_AppSet.m_McNrwDataColor);
    m_NrwDataButton.signal_color_set().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_nrw_data_color_set));
    m_AccessBitsButton.set_rgba(g_AppSet.m_McAccessBitsColor);
    m_AccessBitsButton.signal_color_set().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_access_bits_color_set));
    m_AccessBitsRoButton.set_rgba(g_AppSet.m_McAccessBitsRoColor);
    m_AccessBitsRoButton.signal_color_set().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_access_bits_ro_color_set));
    m_KeyButton.set_rgba(g_AppSet.m_McKeyColor);
    m_KeyButton.signal_color_set().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_key_color_set));
    m_NrwKeyButton.set_rgba(g_AppSet.m_McNrwKeyColor);
    m_NrwKeyButton.signal_color_set().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_nrw_key_color_set));

    m_CardDataGrid.set_expand();
    m_CardDataGrid.set_block_size(16);
    const char* kTitles[3] = {"Б", "С", "б"};
    m_CardDataGrid.set_fix_col_titles(kTitles, std::size(kTitles));
    m_CardDataGrid.add_sector_size(0, 4);
    m_CardDataGrid.add_sector_size(128, 16);
    m_CardDataGrid.update();
    m_CardDataGrid.signal_get_byte_access().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_data_get_byte_access));
    m_CardDataGrid.signal_select_cell().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_data_grid_select_cell));

    m_DataLegendFrame.set_child(m_DataLegendGrid);
    m_DataLegendGrid.set_column_spacing(5);
    m_DataLegendGrid.set_row_spacing(1);
    m_DataLegendGrid.attach(m_SerialButton, 0, 0);
    m_DataLegendGrid.attach(m_SerialLabel, 1, 0);
    m_DataLegendGrid.attach(m_UserDataButton, 0, 1);
    m_DataLegendGrid.attach(m_UserDataLabel, 1, 1);
    m_DataLegendGrid.attach(m_UserDataRoButton, 0, 2);
    m_DataLegendGrid.attach(m_UserDataRoLabel, 1, 2);
    m_DataLegendGrid.attach(m_ValueButton, 0, 3);
    m_DataLegendGrid.attach(m_ValueLabel, 1, 3);
    m_DataLegendGrid.attach(m_ValueDtrButton, 0, 4);
    m_DataLegendGrid.attach(m_ValueDtrLabel, 1, 4);
    m_DataLegendGrid.attach(m_NrwDataButton, 0, 5);
    m_DataLegendGrid.attach(m_NrwDataLabel, 1, 5);

    // Create actions:
    auto refActionGroup = Gio::SimpleActionGroup::create();
    refActionGroup->add_action("read_sector",
                               sigc::mem_fun(*this, &CMifareClassicDialog::on_menu_read_sector));
    refActionGroup->add_action("read_group",
                               sigc::mem_fun(*this, &CMifareClassicDialog::on_menu_read_group));
    refActionGroup->add_action("read_all",
                               sigc::mem_fun(*this, &CMifareClassicDialog::on_menu_read_all));
    refActionGroup->add_action("write_sector",
                               sigc::mem_fun(*this, &CMifareClassicDialog::on_menu_write_sector));
    refActionGroup->add_action("write_group",
                               sigc::mem_fun(*this, &CMifareClassicDialog::on_menu_write_group));
    refActionGroup->add_action("write_all",
                               sigc::mem_fun(*this, &CMifareClassicDialog::on_menu_write_all));
    m_refFormatAction = refActionGroup->add_action_radio_integer(
        "format", sigc::mem_fun(*this, &CMifareClassicDialog::on_menu_format), 1);
    insert_action_group("popup1", refActionGroup);

    m_refBuilder = Gtk::Builder::create();
    // Layout the actions in a menubar and toolbar:
    Glib::ustring ui_info =
        "<interface>"
        "  <menu id='menu-popup1'>"
        "    <section>"
        "      <item>"
        "        <attribute name='label' translatable='yes'>Читать сектор</attribute>"
        "        <attribute name='action'>popup1.read_sector</attribute>"
        "      </item>"
        "      <item>"
        "        <attribute name='label' translatable='yes'>Читать группу</attribute>"
        "        <attribute name='action'>popup1.read_group</attribute>"
        "      </item>"
        "      <item>"
        "        <attribute name='label' translatable='yes'>Читать все</attribute>"
        "        <attribute name='action'>popup1.read_all</attribute>"
        "      </item>"
        "    </section>"
        "    <section>"
        "      <item>"
        "        <attribute name='label' translatable='yes'>Записать сектор</attribute>"
        "        <attribute name='action'>popup1.write_sector</attribute>"
        "      </item>"
        "      <item>"
        "        <attribute name='label' translatable='yes'>Записать группу</attribute>"
        "        <attribute name='action'>popup1.write_group</attribute>"
        "      </item>"
        "      <item>"
        "        <attribute name='label' translatable='yes'>Записать все</attribute>"
        "        <attribute name='action'>popup1.write_all</attribute>"
        "      </item>"
        "    </section>"
        "    <section>"
        "    <submenu>"
        "      <attribute name='label' translatable='yes'>Формат данных</attribute>"
        "      <section>"
        "        <item>"
        "          <attribute name='label' translatable='yes'>Шестнадцатеричный</attribute>"
        "          <attribute name='action'>popup1.format</attribute>"
        "          <attribute name='target' type='i'>1</attribute>"
        "        </item>"
        "        <item>"
        "          <attribute name='label' translatable='yes'>Десятичный</attribute>"
        "          <attribute name='action'>popup1.format</attribute>"
        "          <attribute name='target' type='i'>2</attribute>"
        "        </item>"
        "        <item>"
        "          <attribute name='label' translatable='yes'>Восьмеричный</attribute>"
        "          <attribute name='action'>popup1.format</attribute>"
        "          <attribute name='target' type='i'>3</attribute>"
        "        </item>"
        "        <item>"
        "          <attribute name='label' translatable='yes'>Двоичный</attribute>"
        "          <attribute name='action'>popup1.format</attribute>"
        "          <attribute name='target' type='i'>4</attribute>"
        "        </item>"
        "      </section>"
        "    </submenu>"
        "    </section>"
        "  </menu>"
        "</interface>";

    try {
        m_refBuilder->add_from_string(ui_info);
    }
    catch (const Glib::Error& ex) {
        std::cerr << "building menus failed: " << ex.what();
    }

    // Get the menu:
    auto gmenu = m_refBuilder->get_object<Gio::Menu>("menu-popup1");
    if (!gmenu)
        g_warning("GMenu not found");

    m_MenuPopup.set_parent(m_CardDataGrid);
    m_MenuPopup.set_menu_model(gmenu);
    m_MenuPopup.set_has_arrow(false);

    m_refRClick = Gtk::GestureClick::create();
    m_refRClick->set_button(GDK_BUTTON_SECONDARY);
    m_refRClick->signal_pressed().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_data_grid_rclick));
    m_CardDataGrid.add_controller(m_refRClick);

    m_SerialLabel.set_halign(Gtk::Align::START);
    m_SerialLabel.set_mnemonic_widget(m_SerialButton);
    m_UserDataLabel.set_halign(Gtk::Align::START);
    m_UserDataLabel.set_mnemonic_widget(m_UserDataButton);
    m_UserDataRoLabel.set_halign(Gtk::Align::START);
    m_ValueLabel.set_halign(Gtk::Align::START);
    m_ValueDtrLabel.set_halign(Gtk::Align::START);
    m_NrwDataLabel.set_halign(Gtk::Align::START);

    m_TrailerLegendFrame.set_child(m_TrailerLegendGrid);
    m_TrailerLegendGrid.set_column_spacing(5);
    m_TrailerLegendGrid.set_row_spacing(1);
    m_TrailerLegendGrid.attach(m_AccessBitsButton, 0, 0);
    m_TrailerLegendGrid.attach(m_AccessBitsLabel, 1, 0);
    m_TrailerLegendGrid.attach(m_AccessBitsRoButton, 0, 1);
    m_TrailerLegendGrid.attach(m_AccessBitsRoLabel, 1, 1);
    m_TrailerLegendGrid.attach(m_KeyButton, 0, 2);
    m_TrailerLegendGrid.attach(m_KeyLabel, 1, 2);
    m_TrailerLegendGrid.attach(m_NrwKeyButton, 0, 3);
    m_TrailerLegendGrid.attach(m_NrwKeyLabel, 1, 3);

    m_AccessBitsLabel.set_halign(Gtk::Align::START);
    m_AccessBitsRoLabel.set_halign(Gtk::Align::START);
    m_KeyLabel.set_halign(Gtk::Align::START);
    m_NrwKeyLabel.set_halign(Gtk::Align::START);

    m_FormatFrame.set_valign(Gtk::Align::START);
    m_FormatFrame.set_child(m_FormatBox);
    m_FormatBox.set_margin(5);
    m_FormatBox.append(m_HexCheckButton);
    m_FormatBox.append(m_DecCheckButton);
    m_FormatBox.append(m_OctCheckButton);
    m_FormatBox.append(m_BinCheckButton);

    m_DecCheckButton.set_group(m_HexCheckButton);
    m_OctCheckButton.set_group(m_DecCheckButton);
    m_BinCheckButton.set_group(m_OctCheckButton);
    m_HexCheckButton.signal_toggled().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_hex_toggled));
    m_DecCheckButton.signal_toggled().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_dec_toggled));
    m_OctCheckButton.signal_toggled().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_oct_toggled));
    m_BinCheckButton.signal_toggled().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_bin_toggled));

    m_SectorFrame.set_vexpand(false);
    m_SectorFrame.set_child(m_SectorBox);
    m_SectorBox.set_margin(5);
    m_SectorBox.append(m_ValueBlockFrame);
    m_SectorBox.append(m_SectorKeysFrame);
    m_SectorBox.append(m_SectorTrailerFrame);
    m_SectorBox.append(m_SectorUserDataFrame);

    m_ValueBlockFrame.set_child(m_ValueGrid);
    m_ValueGrid.set_margin(5);
    m_ValueGrid.set_column_spacing(5);
    m_ValueGrid.set_row_spacing(5);
    m_ValueGrid.attach(m_Value2Label, 0, 0);
    m_ValueGrid.attach(m_ValueSpinButton, 1, 0);
    m_ValueGrid.attach(m_AddressLabel, 2, 0);
    m_ValueGrid.attach(m_AddressSpinButton, 3, 0);
    m_ValueGrid.attach(m_ValueDeltaLabel, 0, 1);
    m_ValueGrid.attach(m_ValueDeltaSpinButton, 1, 1);
    m_ValueGrid.attach(m_IncrementButton, 2, 1);
    m_ValueGrid.attach(m_DecrementButton, 3, 1);
    m_ValueGrid.attach(m_TransferButton, 4, 1);
    m_ValueGrid.attach(m_RestoreButton, 5, 1);

    m_Value2Label.set_halign(Gtk::Align::END);
    m_AddressLabel.set_halign(Gtk::Align::END);
    m_ValueDeltaLabel.set_halign(Gtk::Align::END);
    m_ValueSpinButton.signal_changed().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_value_block_value_changed));
    m_IncrementButton.signal_clicked().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_value_block_increment));
    m_DecrementButton.signal_clicked().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_value_block_decrement));
    m_TransferButton.signal_clicked().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_value_block_transfer));
    m_RestoreButton.signal_clicked().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_value_block_restore));
    m_AddressSpinButton.signal_changed().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_value_block_address_changed));

    m_SectorKeysFrame.set_child(m_SectorKeysBox);
    m_SectorKeysBox.set_margin(5);
    m_SectorKeysBox.set_spacing(5);
    m_SectorKeysBox.append(m_SectorKeyALabel);
    m_SectorKeysBox.append(m_SectorKeyAEntry);
    m_SectorKeysBox.append(m_SectorKeyAButton);
    m_SectorKeysBox.append(m_SectorKeyBLabel);
    m_SectorKeysBox.append(m_SectorKeyBEntry);
    m_SectorKeysBox.append(m_SectorKeyBButton);

    m_SectorKeyAButton.signal_clicked().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_button_sector_key_a));
    m_SectorKeyBButton.signal_clicked().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_button_sector_key_b));

    // Load extra CSS file.
    m_refCssProvider = Gtk::CssProvider::create();
#if HAS_STYLE_PROVIDER_ADD_PROVIDER_FOR_DISPLAY
    Gtk::StyleProvider::add_provider_for_display(get_display(), m_refCssProvider,
                                                 GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
#else
    Gtk::StyleContext::add_provider_for_display(get_display(), m_refCssProvider,
                                                GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
#endif
    std::string sCSS =
        ".key {"
        "  font-family:monospace; "
        "}";
    m_refCssProvider->load_from_data(sCSS);
    m_ExplicitKeyEntry.add_css_class("key");
    m_SectorKeyAEntry.add_css_class("key");
    m_SectorKeyBEntry.add_css_class("key");

    m_SectorTrailerFrame.set_child(m_TrailerColumnView);
    configure_trailer_column_view(m_TrailerColumnView, m_TrailerListStore, false);
    m_TrailerColumnView.signal_activate().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_trailer_column_view_activate));

    m_TrailerPopover.set_parent(m_TrailerColumnView);
    m_TrailerPopover.set_child(m_PTrailerColumnView);
    m_TrailerPopover.set_margin(5);
    configure_trailer_column_view(m_PTrailerColumnView, m_PTrailerListStore, true);
    m_PTrailerColumnView.signal_activate().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_popover_trailer_column_view_activate));

    m_SectorUserDataFrame.set_child(m_UserDataColumnView);
    configure_userdata_column_view(m_UserDataColumnView, m_UserDataListStore, false);
    m_UserDataColumnView.signal_activate().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_user_data_column_view_activate));

    m_UserDataPopover.set_parent(m_UserDataColumnView);
    m_UserDataPopover.set_child(m_PUserDataColumnView);
    m_UserDataPopover.set_margin(5);
    configure_userdata_column_view(m_PUserDataColumnView, m_PUserDataListStore, true);
    m_PUserDataColumnView.signal_activate().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_popover_user_data_column_view_activate));

    m_BottomBox.set_margin(5);
    m_BottomBox.set_spacing(5);
    m_BottomBox.append(m_ReadButton);
    m_BottomBox.append(m_WriteButton);
    m_BottomBox.append(m_ErrorsButton);

    m_ReadButton.signal_clicked().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_button_read));
    m_WriteButton.signal_clicked().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_button_write));
    m_ErrorsButton.signal_clicked().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_button_errors));

    signal_hide().connect(sigc::mem_fun(*this, &CMifareClassicDialog::on_hide));
}

CMifareClassicDialog::~CMifareClassicDialog() {
    m_MenuPopup.unparent();
    m_TrailerPopover.unparent();
    m_UserDataPopover.unparent();
}

void CMifareClassicDialog::Init(const ilr::CReader& oReader,
                                Glib::RefPtr<CMifareReaderSettings> refSets,
                                Glib::RefPtr<CMfClassicKeysSettings> refKeys) {
    m_oReader = oReader.Clone();
    m_refSets = refSets;
    m_refKeys = refKeys;
    ilr_card_info rInfo;
    m_oReader.GetCardInfo(rInfo);
    m_CardUid = rInfo.rUID;
    set_title(Glib::ustring::format(ilr::kCardTypeNames[rInfo.nType],
                                    ilr::CardUIDToStr(rInfo.nType, rInfo.rUID)));

    SelectFormat(g_AppSet.m_nDataFormat);

    auto nMaxBlocks = ilr::GetNumberOfMfBlocks(rInfo.nMemSize);
    m_oOldBlocks.resize(nMaxBlocks);
    m_oNewBlocks.resize(nMaxBlocks);
    m_oSectors.resize(ilr::GetMfSectorByBlock(nMaxBlocks));
    m_CardDataGrid.set_data_pointer((uint8_t*)m_oNewBlocks.data(), m_oNewBlocks.size() * 16);
    m_CardDataGrid.set_old_data_pointer((uint8_t*)m_oOldBlocks.data(), m_oNewBlocks.size() * 16);
    m_AuthKey = g_AppSet.m_McAuthKey;
    m_fAuthByRdKeys = g_AppSet.m_fMfAuthRdKeys;
    m_fAuthKeyB = g_AppSet.m_fMfAuthKeyB;
    SetViewDataRange(0, 4);
    UpdateAuthGroupData(false);
    UpdateGroupListBox();
    ReadCardData();
}

void CMifareClassicDialog::on_explicit_key_button_clicked() {
    UpdateAuthGroupData(true);
    if (nullptr == m_refKeysDialog)
        m_refKeysDialog.reset(new CMcKeysDialog());
    m_refKeysDialog->set_transient_for(*this);
    m_refKeysDialog->set_modal();
    m_refKeysDialog->set_hide_on_close();
    m_refKeysDialog->signal_hide().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_keys_dialog_hide));

    m_refKeysDialog->m_nCurrentKey = m_AuthKey;
    m_refKeysDialog->Init(m_refKeys, m_refSets);
    m_refKeysDialog->set_visible(true);
}

void CMifareClassicDialog::on_keys_dialog_hide() {
    if (m_refKeysDialog->m_fAccept && (m_refKeysDialog->m_nCurrentKey != -1)) {
        m_AuthKey = m_refKeysDialog->m_nCurrentKey;
        UpdateAuthGroupData(false);
    }
    m_refKeysDialog = nullptr;
}

void CMifareClassicDialog::on_reader_keys_button_clicked() {
    UpdateAuthRdKeysCtrlData(true);
    if (nullptr == m_refRdKeysDialog)
        m_refRdKeysDialog.reset(new CReaderMcKeysDialog());
    m_refRdKeysDialog->set_transient_for(*this);
    m_refRdKeysDialog->set_modal();
    m_refRdKeysDialog->set_hide_on_close();
    m_refRdKeysDialog->signal_hide().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_rdkeys_dialog_hide));

    m_refRdKeysDialog->Init(m_oReader, m_refSets);
    m_refRdKeysDialog->set_visible(true);
}

void CMifareClassicDialog::on_rdkeys_dialog_hide() {
    m_refRdKeysDialog = nullptr;
    UpdateAuthRdKeysCtrlData(false);
}

void CMifareClassicDialog::on_group_selected_row_changed() {
    auto pRow = m_GroupListBox.get_selected_row();
    if (pRow != nullptr) {
        auto nIdx = pRow->get_index();
        auto nCount = m_GroupListRows.size();
        size_t nBlockIdx, nBlockCount;
        if (nIdx == (nCount - 1)) {
            nBlockIdx = 0;
            nBlockCount = m_oNewBlocks.size();
        }
        else if (m_oNewBlocks.size() > 128) {
            if (nIdx == (nCount - 2)) {
                nBlockIdx = 128;
                nBlockCount = (m_oNewBlocks.size() - nBlockIdx);
            }
            else if (nIdx == (nCount - 3)) {
                nBlockIdx = 0;
                nBlockCount = std::min(m_oNewBlocks.size(), 128LU);
            }
            else {
                nBlockIdx = ilr::GetMfBlockBySector(nIdx);
                nBlockCount = ilr::GetMfSectorBlockCount(nIdx);
            }
        }
        else {
            nBlockIdx = ilr::GetMfBlockBySector(nIdx);
            nBlockCount = ilr::GetMfSectorBlockCount(nIdx);
        }

        if ((m_CardDataGrid.get_first_visible_block() != nBlockIdx) ||
            (m_CardDataGrid.get_visible_block_count() != nBlockCount)) {
            SetViewDataRange(nBlockIdx, nBlockCount);

            auto fNeedRead = false;
            auto nSectorIdx = ilr::GetMfSectorByBlock(nBlockIdx);
            auto nEnd = ilr::GetMfSectorByBlock(nBlockIdx + nBlockCount);
            for (size_t i = nSectorIdx; i < nEnd; i++) {
                if (!m_oSectors[i].m_fReadDataOk) {
                    fNeedRead = true;
                    break;
                }
            }
            if (fNeedRead)
                ReadCardData(nSectorIdx, nEnd - nSectorIdx);

            auto nCurrentBlockIdx = m_CardDataGrid.row_to_block_idx(m_CardDataGrid.get_row());
            if (nCurrentBlockIdx != -1) {
                nSectorIdx = ilr::GetMfSectorByBlock(nCurrentBlockIdx);
                if (m_nSectorIdx != nSectorIdx) {
                    m_nSectorIdx = nSectorIdx;
                    UpdateValueBlockGroup();
                    UpdateSectorConfigGroup();
                }
            }
        }
    }
}

void CMifareClassicDialog::on_explicit_key_toggled() {
    m_AuthKeysNotebook.set_current_page(0);
}

void CMifareClassicDialog::on_reader_keys_toggled() {
    m_AuthKeysNotebook.set_current_page(1);
}

uint CMifareClassicDialog::on_data_get_byte_access(uint nAddress) {
    if (nAddress < 16)
        return 0;
    auto nBlockIdx = (nAddress / 16);
    size_t nSectorIdx, nSBlockIdx, nSBlockCount;
    ilr::GetMfBlockInfo(nBlockIdx, nSectorIdx, nSBlockIdx, nSBlockCount);
    if (nSectorIdx < m_oSectors.size()) {
        auto& oSector = m_oSectors[nSectorIdx];
        if (GET_BIT(oSector.m_nInitBlocks, nSBlockIdx) && (nSBlockIdx != (nSBlockCount - 1))) {
            auto nSectorAccess =
                ilr::GetMfAccessBits(m_oOldBlocks[nBlockIdx - nSBlockIdx + nSBlockCount - 1]);

            auto nAreaIdx = ilr::GetMfAreaByBlockIdx(nBlockIdx);
            uint32_t nAreaAccess;
            if (ilr::TryGetMfAreaAccess(nSectorAccess, nAreaIdx, nAreaAccess)) {
                switch (nAreaAccess) {
                case 0:  // 0 0 0
                    return 0xff;

                case 1:  // 1 0 0
                case 3:  // 1 1 0
                case 6:  // 0 1 1
                    if (oSector.m_fKeyB)
                        return 0xff;
                    break;
                }
            }
        }
    }
    return 0;
}

void CMifareClassicDialog::on_data_grid_select_cell() {
    auto nBlockIdx = m_CardDataGrid.row_to_block_idx(m_CardDataGrid.get_row());
    auto nSectorIdx = (nBlockIdx != -1) ? ilr::GetMfSectorByBlock(nBlockIdx) : -1;
    if (m_nSectorIdx != nSectorIdx)
        UpdateSectorConfigGroup();
    UpdateValueBlockGroup();
}

void CMifareClassicDialog::on_data_grid_rclick(int n_press, double x, double y) {
    const Gdk::Rectangle rect(x, y, 1, 1);
    m_MenuPopup.set_pointing_to(rect);
    m_MenuPopup.popup();
}

void CMifareClassicDialog::on_menu_read_sector() {
    ReadCurrentSector();
}

void CMifareClassicDialog::on_menu_read_group() {
    ReadCurrentGroup();
}

void CMifareClassicDialog::on_menu_read_all() {
    ReadCardData();
}

void CMifareClassicDialog::on_menu_write_sector() {
    WriteSector();
}

void CMifareClassicDialog::on_menu_write_group() {
    WriteGroup();
}

void CMifareClassicDialog::on_menu_write_all() {
    WriteCardData();
}

void CMifareClassicDialog::on_menu_format(int parameter) {
    m_refFormatAction->change_state(parameter);

    if ((parameter > 0) && (parameter < byte_format::BYTE_FORMAT_SIZE)) {
        SelectFormat((byte_format)parameter);
    }
}

void CMifareClassicDialog::on_serial_color_set() {
    g_AppSet.SetMcSerialColor(m_SerialButton.get_rgba());
    UpdateDataGridColors();
}

void CMifareClassicDialog::on_user_data_color_set() {
    g_AppSet.SetMcUserDataColor(m_UserDataButton.get_rgba());
    UpdateDataGridColors();
}

void CMifareClassicDialog::on_user_data_ro_color_set() {
    g_AppSet.SetMcUserDataRoColor(m_UserDataRoButton.get_rgba());
    UpdateDataGridColors();
}

void CMifareClassicDialog::on_value_color_set() {
    g_AppSet.SetMcValueColor(m_ValueButton.get_rgba());
    UpdateDataGridColors();
}

void CMifareClassicDialog::on_value_dtr_color_set() {
    g_AppSet.SetMcValueDtrColor(m_ValueDtrButton.get_rgba());
    UpdateDataGridColors();
}

void CMifareClassicDialog::on_nrw_data_color_set() {
    g_AppSet.SetMcNrwDataColor(m_NrwDataButton.get_rgba());
    UpdateDataGridColors();
}

void CMifareClassicDialog::on_access_bits_color_set() {
    g_AppSet.SetMcAccessBitsColor(m_AccessBitsButton.get_rgba());
    UpdateDataGridColors();
}

void CMifareClassicDialog::on_access_bits_ro_color_set() {
    g_AppSet.SetMcAccessBitsRoColor(m_AccessBitsRoButton.get_rgba());
    UpdateDataGridColors();
}

void CMifareClassicDialog::on_key_color_set() {
    g_AppSet.SetMcKeyColor(m_KeyButton.get_rgba());
    UpdateDataGridColors();
}

void CMifareClassicDialog::on_nrw_key_color_set() {
    g_AppSet.SetMcNrwKeyColor(m_NrwKeyButton.get_rgba());
    UpdateDataGridColors();
}

void CMifareClassicDialog::on_hex_toggled() {
    if (!m_fLockUpdate && m_HexCheckButton.get_active())
        SelectFormat(CCardDataGrid::BYTE_FORMAT_HEX);
}

void CMifareClassicDialog::on_dec_toggled() {
    if (!m_fLockUpdate && m_DecCheckButton.get_active())
        SelectFormat(CCardDataGrid::BYTE_FORMAT_DEC);
}

void CMifareClassicDialog::on_oct_toggled() {
    if (!m_fLockUpdate && m_OctCheckButton.get_active())
        SelectFormat(CCardDataGrid::BYTE_FORMAT_OCT);
}

void CMifareClassicDialog::on_bin_toggled() {
    if (!m_fLockUpdate && m_BinCheckButton.get_active())
        SelectFormat(CCardDataGrid::BYTE_FORMAT_BIN);
}

void CMifareClassicDialog::on_value_block_value_changed() {
    if (m_fLockUpdate)
        return;
    auto nBlockIdx = m_CardDataGrid.row_to_block_idx(m_CardDataGrid.get_row());
    if (-1 == nBlockIdx)
        return;
    auto nValue = m_ValueSpinButton.get_value_as_int();
    SetValueBlockValue(nBlockIdx, nValue);
}

void CMifareClassicDialog::on_value_block_increment() {
    auto nBlockIdx = m_CardDataGrid.row_to_block_idx(m_CardDataGrid.get_row());
    if (-1 == nBlockIdx)
        return;
    auto nValue = m_ValueDeltaSpinButton.get_value_as_int();
    m_oReader.MfIncrement(nBlockIdx, nValue);
}

void CMifareClassicDialog::on_value_block_decrement() {
    auto nBlockIdx = m_CardDataGrid.row_to_block_idx(m_CardDataGrid.get_row());
    if (-1 == nBlockIdx)
        return;
    auto nValue = m_ValueDeltaSpinButton.get_value_as_int();
    m_oReader.MfDecrement(nBlockIdx, nValue);
}

void CMifareClassicDialog::on_value_block_transfer() {
    auto nBlockIdx = m_CardDataGrid.row_to_block_idx(m_CardDataGrid.get_row());
    if (-1 == nBlockIdx)
        return;
    m_oReader.MfTransfer(nBlockIdx);
}

void CMifareClassicDialog::on_value_block_restore() {
    auto nBlockIdx = m_CardDataGrid.row_to_block_idx(m_CardDataGrid.get_row());
    if (-1 == nBlockIdx)
        return;
    m_oReader.MfRestore(nBlockIdx);
}

void CMifareClassicDialog::on_value_block_address_changed() {
    if (m_fLockUpdate)
        return;
    auto nBlockIdx = m_CardDataGrid.row_to_block_idx(m_CardDataGrid.get_row());
    if (-1 == nBlockIdx)
        return;
    auto nValue = m_AddressSpinButton.get_value_as_int();
    SetValueBlockAddress(nBlockIdx, nValue);
}

void CMifareClassicDialog::on_button_sector_key_a() {
    if (nullptr == m_refKeysDialog)
        m_refKeysDialog.reset(new CMcKeysDialog());
    m_refKeysDialog->set_transient_for(*this);
    m_refKeysDialog->set_modal();
    m_refKeysDialog->set_hide_on_close();
    m_refKeysDialog->signal_hide().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_sector_key_a_keys_dialog_hide));

    ilr::CMifareClassicKey oKey;
    if (oKey.TryParse(m_SectorKeyAEntry.get_text().c_str()))
        m_refKeysDialog->m_nCurrentKey = oKey;

    m_refKeysDialog->Init(m_refKeys, m_refSets);
    m_refKeysDialog->set_visible(true);
}

void CMifareClassicDialog::on_sector_key_a_keys_dialog_hide() {
    if (m_refKeysDialog->m_fAccept && (m_refKeysDialog->m_nCurrentKey != -1)) {
        ilr::CMifareClassicKey oKey(m_refKeysDialog->m_nCurrentKey);
        m_SectorKeyAEntry.set_text(oKey.ToString());
    }
    m_refKeysDialog = nullptr;
}

void CMifareClassicDialog::on_button_sector_key_b() {
    if (nullptr == m_refKeysDialog)
        m_refKeysDialog.reset(new CMcKeysDialog());
    m_refKeysDialog->set_transient_for(*this);
    m_refKeysDialog->set_modal();
    m_refKeysDialog->set_hide_on_close();
    m_refKeysDialog->signal_hide().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_sector_key_b_keys_dialog_hide));

    ilr::CMifareClassicKey oKey;
    if (oKey.TryParse(m_SectorKeyBEntry.get_text().c_str()))
        m_refKeysDialog->m_nCurrentKey = oKey;

    m_refKeysDialog->Init(m_refKeys, m_refSets);
    m_refKeysDialog->set_visible(true);
}

void CMifareClassicDialog::on_sector_key_b_keys_dialog_hide() {
    if (m_refKeysDialog->m_fAccept && (m_refKeysDialog->m_nCurrentKey != -1)) {
        ilr::CMifareClassicKey oKey(m_refKeysDialog->m_nCurrentKey);
        m_SectorKeyBEntry.set_text(oKey.ToString());
    }
    m_refKeysDialog = nullptr;
}

void CMifareClassicDialog::on_setup_label(const Glib::RefPtr<Gtk::ListItem>& list_item) {
    list_item->set_child(*Gtk::make_managed<Gtk::Label>(""));
}

void CMifareClassicDialog::on_trailer_bind_bits(const Glib::RefPtr<Gtk::ListItem>& list_item) {
    auto col = std::dynamic_pointer_cast<CTrailerModelColumns>(list_item->get_item());
    if (!col)
        return;
    auto label = dynamic_cast<Gtk::Label*>(list_item->get_child());
    if (!label)
        return;
    Glib::Binding::bind_property_value(
        col->m_property_bits.get_proxy(), label->property_label(),
        Glib::Binding::Flags::SYNC_CREATE,
        sigc::mem_fun(*this, &CMifareClassicDialog::area_bits_transform_to));
}

bool CMifareClassicDialog::area_bits_transform_to(const GValue* a, GValue* b) {
    if ((a->g_type != G_TYPE_UINT) || (b->g_type != G_TYPE_STRING))
        return false;
    auto nSrc = g_value_get_uint(a);
    g_value_set_string(
        b, Glib::ustring::sprintf("%u %u %u", (nSrc & 1), ((nSrc >> 1) & 1), ((nSrc >> 2) & 1))
               .c_str());
    return true;
}

void CMifareClassicDialog::on_trailer_bind_read_a(const Glib::RefPtr<Gtk::ListItem>& list_item) {
    auto col = std::dynamic_pointer_cast<CTrailerModelColumns>(list_item->get_item());
    if (!col)
        return;
    auto label = dynamic_cast<Gtk::Label*>(list_item->get_child());
    if (!label)
        return;
    label->set_label(kNoAccessStr);
}

void CMifareClassicDialog::on_trailer_bind_write_a(const Glib::RefPtr<Gtk::ListItem>& list_item) {
    auto col = std::dynamic_pointer_cast<CTrailerModelColumns>(list_item->get_item());
    if (!col)
        return;
    auto label = dynamic_cast<Gtk::Label*>(list_item->get_child());
    if (!label)
        return;
    Glib::Binding::bind_property_value(
        col->m_property_bits.get_proxy(), label->property_label(),
        Glib::Binding::Flags::SYNC_CREATE,
        sigc::mem_fun(*this, &CMifareClassicDialog::trailer_write_a_transform_to));
}

bool CMifareClassicDialog::trailer_write_a_transform_to(const GValue* a, GValue* b) {
    if ((a->g_type != G_TYPE_UINT) || (b->g_type != G_TYPE_STRING))
        return false;
    auto nSrc = g_value_get_uint(a);
    switch (nSrc) {
    case 0:  // 0 0 0
    case 4:  // 0 0 1
        g_value_set_string(b, kKeyAAccessStr);
        return true;

    case 1:  // 1 0 0
    case 6:  // 0 1 1
        g_value_set_string(b, kKeyBAccessStr);
        return true;
    }
    g_value_set_string(b, kNoAccessStr);
    return true;
}

void CMifareClassicDialog::on_trailer_bind_read_access(
    const Glib::RefPtr<Gtk::ListItem>& list_item) {
    auto col = std::dynamic_pointer_cast<CTrailerModelColumns>(list_item->get_item());
    if (!col)
        return;
    auto label = dynamic_cast<Gtk::Label*>(list_item->get_child());
    if (!label)
        return;
    Glib::Binding::bind_property_value(
        col->m_property_bits.get_proxy(), label->property_label(),
        Glib::Binding::Flags::SYNC_CREATE,
        sigc::mem_fun(*this, &CMifareClassicDialog::trailer_read_access_transform_to));
}

bool CMifareClassicDialog::trailer_read_access_transform_to(const GValue* a, GValue* b) {
    if ((a->g_type != G_TYPE_UINT) || (b->g_type != G_TYPE_STRING))
        return false;
    auto nSrc = g_value_get_uint(a);
    switch (nSrc) {
    case 0:  // 0 0 0
    case 2:  // 0 1 0
    case 4:  // 0 0 1
        g_value_set_string(b, kKeyAAccessStr);
        return true;
    }
    g_value_set_string(b, kKeyAorBAccessStr);
    return true;
}

void CMifareClassicDialog::on_trailer_bind_write_access(
    const Glib::RefPtr<Gtk::ListItem>& list_item) {
    auto col = std::dynamic_pointer_cast<CTrailerModelColumns>(list_item->get_item());
    if (!col)
        return;
    auto label = dynamic_cast<Gtk::Label*>(list_item->get_child());
    if (!label)
        return;
    Glib::Binding::bind_property_value(
        col->m_property_bits.get_proxy(), label->property_label(),
        Glib::Binding::Flags::SYNC_CREATE,
        sigc::mem_fun(*this, &CMifareClassicDialog::trailer_write_access_transform_to));
}

bool CMifareClassicDialog::trailer_write_access_transform_to(const GValue* a, GValue* b) {
    if ((a->g_type != G_TYPE_UINT) || (b->g_type != G_TYPE_STRING))
        return false;
    auto nSrc = g_value_get_uint(a);
    switch (nSrc) {
    case 4:  // 0 0 1
        g_value_set_string(b, kKeyAAccessStr);
        return true;
    case 6:  // 0 1 1
    case 5:  // 1 0 1
        g_value_set_string(b, kKeyBAccessStr);
        return true;
    }
    g_value_set_string(b, kNoAccessStr);
    return true;
}

void CMifareClassicDialog::on_trailer_bind_read_b(const Glib::RefPtr<Gtk::ListItem>& list_item) {
    auto col = std::dynamic_pointer_cast<CTrailerModelColumns>(list_item->get_item());
    if (!col)
        return;
    auto label = dynamic_cast<Gtk::Label*>(list_item->get_child());
    if (!label)
        return;
    Glib::Binding::bind_property_value(
        col->m_property_bits.get_proxy(), label->property_label(),
        Glib::Binding::Flags::SYNC_CREATE,
        sigc::mem_fun(*this, &CMifareClassicDialog::trailer_read_b_transform_to));
}

bool CMifareClassicDialog::trailer_read_b_transform_to(const GValue* a, GValue* b) {
    if ((a->g_type != G_TYPE_UINT) || (b->g_type != G_TYPE_STRING))
        return false;
    auto nSrc = g_value_get_uint(a);
    switch (nSrc) {
    case 0:  // 0 0 0
    case 2:  // 0 1 0
    case 4:  // 0 0 1
        g_value_set_string(b, kKeyAAccessStr);
        return true;
    }
    g_value_set_string(b, kNoAccessStr);
    return true;
}

void CMifareClassicDialog::on_trailer_bind_write_b(const Glib::RefPtr<Gtk::ListItem>& list_item) {
    auto col = std::dynamic_pointer_cast<CTrailerModelColumns>(list_item->get_item());
    if (!col)
        return;
    auto label = dynamic_cast<Gtk::Label*>(list_item->get_child());
    if (!label)
        return;
    Glib::Binding::bind_property_value(
        col->m_property_bits.get_proxy(), label->property_label(),
        Glib::Binding::Flags::SYNC_CREATE,
        sigc::mem_fun(*this, &CMifareClassicDialog::trailer_write_b_transform_to));
}

bool CMifareClassicDialog::trailer_write_b_transform_to(const GValue* a, GValue* b) {
    if ((a->g_type != G_TYPE_UINT) || (b->g_type != G_TYPE_STRING))
        return false;
    auto nSrc = g_value_get_uint(a);
    switch (nSrc) {
    case 0:  // 0 0 0
    case 4:  // 0 0 1
        g_value_set_string(b, kKeyAAccessStr);
        return true;

    case 1:  // 1 0 0
    case 6:  // 0 1 1
        g_value_set_string(b, kKeyBAccessStr);
        return true;
    }
    g_value_set_string(b, kNoAccessStr);
    return true;
}

void CMifareClassicDialog::on_trailer_bind_remark(const Glib::RefPtr<Gtk::ListItem>& list_item) {
    auto col = std::dynamic_pointer_cast<CTrailerModelColumns>(list_item->get_item());
    if (!col)
        return;
    auto label = dynamic_cast<Gtk::Label*>(list_item->get_child());
    if (!label)
        return;
    Glib::Binding::bind_property_value(
        col->m_property_bits.get_proxy(), label->property_label(),
        Glib::Binding::Flags::SYNC_CREATE,
        sigc::mem_fun(*this, &CMifareClassicDialog::trailer_remark_transform_to));
}

bool CMifareClassicDialog::trailer_remark_transform_to(const GValue* a, GValue* b) {
    if ((a->g_type != G_TYPE_UINT) || (b->g_type != G_TYPE_STRING))
        return false;
    auto nSrc = g_value_get_uint(a);
    switch (nSrc) {
    case 0:  // 0 0 0
    case 2:  // 0 1 0
        g_value_set_string(b, "Ключ Б может быть прочитан");
        return true;

    case 4:  // 0 0 1
        g_value_set_string(b, "Ключ Б может быть прочитан (новая карта)");
        return true;
    }
    g_value_set_string(b, "");
    return true;
}

void CMifareClassicDialog::on_trailer_column_view_activate(guint pos) {
    const Gdk::Rectangle rect(0, 0, m_TrailerColumnView.get_width(),
                              m_TrailerColumnView.get_height());
    auto nBits = m_TrailerListStore->get_item(0)->m_property_bits.get_value();
    auto pModel = dynamic_cast<Gtk::SingleSelection*>(m_PTrailerColumnView.get_model().get());
    auto nIdx = FindPTrailerBits(nBits);
    if (nIdx != GTK_INVALID_LIST_POSITION)
        pModel->select_item(nIdx, true);
    m_TrailerPopover.set_pointing_to(rect);
    m_TrailerPopover.set_visible(true);
}

void CMifareClassicDialog::on_popover_trailer_column_view_activate(guint pos) {
    m_TrailerPopover.set_visible(false);
    auto item = m_PTrailerListStore->get_item(pos);
    if (item != nullptr)
        SetSectorAreaAccess(m_nSectorIdx, 3, item->m_property_bits);
}

void CMifareClassicDialog::on_user_data_bind_area(const Glib::RefPtr<Gtk::ListItem>& list_item) {
    auto col = std::dynamic_pointer_cast<CUserDataModelColumns>(list_item->get_item());
    if (!col)
        return;
    auto label = dynamic_cast<Gtk::Label*>(list_item->get_child());
    if (!label)
        return;
    Glib::Binding::bind_property_value(
        col->m_property_area.get_proxy(), label->property_label(),
        Glib::Binding::Flags::SYNC_CREATE,
        sigc::mem_fun(*this, &CMifareClassicDialog::area_transform_to));
}

bool CMifareClassicDialog::area_transform_to(const GValue* a, GValue* b) {
    if ((a->g_type != G_TYPE_UINT) || (b->g_type != G_TYPE_STRING))
        return false;
    auto nSrc = g_value_get_uint(a);
    auto nSBlockCount = ilr::GetMfSectorBlockCount(m_nSectorIdx);
    if (4 == nSBlockCount)
        g_value_set_string(b, Glib::ustring::sprintf("%u", nSrc).c_str());
    else {
        auto nBlockIdx = (nSrc * 5);
        g_value_set_string(b, Glib::ustring::sprintf("%u-%u", nBlockIdx, nBlockIdx + 4).c_str());
    }
    return true;
}

void CMifareClassicDialog::on_user_data_bind_bits(const Glib::RefPtr<Gtk::ListItem>& list_item) {
    auto col = std::dynamic_pointer_cast<CUserDataModelColumns>(list_item->get_item());
    if (!col)
        return;
    auto label = dynamic_cast<Gtk::Label*>(list_item->get_child());
    if (!label)
        return;
    Glib::Binding::bind_property_value(
        col->m_property_bits.get_proxy(), label->property_label(),
        Glib::Binding::Flags::SYNC_CREATE,
        sigc::mem_fun(*this, &CMifareClassicDialog::area_bits_transform_to));
}

void CMifareClassicDialog::on_user_data_bind_read(const Glib::RefPtr<Gtk::ListItem>& list_item) {
    auto col = std::dynamic_pointer_cast<CUserDataModelColumns>(list_item->get_item());
    if (!col)
        return;
    auto label = dynamic_cast<Gtk::Label*>(list_item->get_child());
    if (!label)
        return;
    Glib::Binding::bind_property_value(
        col->m_property_bits.get_proxy(), label->property_label(),
        Glib::Binding::Flags::SYNC_CREATE,
        sigc::mem_fun(*this, &CMifareClassicDialog::user_data_read_transform_to));
}

bool CMifareClassicDialog::user_data_read_transform_to(const GValue* a, GValue* b) {
    if ((a->g_type != G_TYPE_UINT) || (b->g_type != G_TYPE_STRING))
        return false;
    auto nSrc = g_value_get_uint(a);
    switch (nSrc) {
    case 0:  // 0 0 0
    case 2:  // 0 1 0
    case 1:  // 1 0 0
    case 3:  // 1 1 0
    case 4:  // 0 0 1
        g_value_set_string(b, kKeyAorBAccessStr);
        return true;

    case 6:  // 0 1 1
    case 5:  // 1 0 1
        g_value_set_string(b, kKeyBAccessStr);
        return true;
    }
    g_value_set_string(b, kNoAccessStr);
    return true;
}

void CMifareClassicDialog::on_user_data_bind_write(const Glib::RefPtr<Gtk::ListItem>& list_item) {
    auto col = std::dynamic_pointer_cast<CUserDataModelColumns>(list_item->get_item());
    if (!col)
        return;
    auto label = dynamic_cast<Gtk::Label*>(list_item->get_child());
    if (!label)
        return;
    Glib::Binding::bind_property_value(
        col->m_property_bits.get_proxy(), label->property_label(),
        Glib::Binding::Flags::SYNC_CREATE,
        sigc::mem_fun(*this, &CMifareClassicDialog::user_data_write_transform_to));
}

bool CMifareClassicDialog::user_data_write_transform_to(const GValue* a, GValue* b) {
    if ((a->g_type != G_TYPE_UINT) || (b->g_type != G_TYPE_STRING))
        return false;
    auto nSrc = g_value_get_uint(a);
    switch (nSrc) {
    case 0:  // 0 0 0
        g_value_set_string(b, kKeyAorBAccessStr);
        return true;

    case 1:  // 1 0 0
    case 3:  // 1 1 0
    case 6:  // 0 1 1
        g_value_set_string(b, kKeyBAccessStr);
        return true;
    }
    g_value_set_string(b, kNoAccessStr);
    return true;
}

void CMifareClassicDialog::on_user_data_bind_increment(
    const Glib::RefPtr<Gtk::ListItem>& list_item) {
    auto col = std::dynamic_pointer_cast<CUserDataModelColumns>(list_item->get_item());
    if (!col)
        return;
    auto label = dynamic_cast<Gtk::Label*>(list_item->get_child());
    if (!label)
        return;
    Glib::Binding::bind_property_value(
        col->m_property_bits.get_proxy(), label->property_label(),
        Glib::Binding::Flags::SYNC_CREATE,
        sigc::mem_fun(*this, &CMifareClassicDialog::user_data_increment_transform_to));
}

bool CMifareClassicDialog::user_data_increment_transform_to(const GValue* a, GValue* b) {
    if ((a->g_type != G_TYPE_UINT) || (b->g_type != G_TYPE_STRING))
        return false;
    auto nSrc = g_value_get_uint(a);
    switch (nSrc) {
    case 0:  // 0 0 0
        g_value_set_string(b, kKeyAorBAccessStr);
        return true;

    case 3:  // 1 1 0
        g_value_set_string(b, kKeyBAccessStr);
        return true;
    }
    g_value_set_string(b, kNoAccessStr);
    return true;
}

void CMifareClassicDialog::on_user_data_bind_dtr(const Glib::RefPtr<Gtk::ListItem>& list_item) {
    auto col = std::dynamic_pointer_cast<CUserDataModelColumns>(list_item->get_item());
    if (!col)
        return;
    auto label = dynamic_cast<Gtk::Label*>(list_item->get_child());
    if (!label)
        return;
    Glib::Binding::bind_property_value(
        col->m_property_bits.get_proxy(), label->property_label(),
        Glib::Binding::Flags::SYNC_CREATE,
        sigc::mem_fun(*this, &CMifareClassicDialog::user_data_dtr_transform_to));
}

bool CMifareClassicDialog::user_data_dtr_transform_to(const GValue* a, GValue* b) {
    if ((a->g_type != G_TYPE_UINT) || (b->g_type != G_TYPE_STRING))
        return false;
    auto nSrc = g_value_get_uint(a);
    switch (nSrc) {
    case 0:  // 0 0 0
    case 3:  // 1 1 0
    case 4:  // 0 0 1
        g_value_set_string(b, kKeyAorBAccessStr);
        return true;
    }
    g_value_set_string(b, kNoAccessStr);
    return true;
}

void CMifareClassicDialog::on_user_data_bind_remark(const Glib::RefPtr<Gtk::ListItem>& list_item) {
    auto col = std::dynamic_pointer_cast<CUserDataModelColumns>(list_item->get_item());
    if (!col)
        return;
    auto label = dynamic_cast<Gtk::Label*>(list_item->get_child());
    if (!label)
        return;
    Glib::Binding::bind_property_value(
        col->m_property_bits.get_proxy(), label->property_label(),
        Glib::Binding::Flags::SYNC_CREATE,
        sigc::mem_fun(*this, &CMifareClassicDialog::user_data_remark_transform_to));
}

bool CMifareClassicDialog::user_data_remark_transform_to(const GValue* a, GValue* b) {
    if ((a->g_type != G_TYPE_UINT) || (b->g_type != G_TYPE_STRING))
        return false;
    auto nSrc = g_value_get_uint(a);
    switch (nSrc) {
    case 0:  // 0 0 0
        g_value_set_string(b, "Новая карта");
        return true;

    case 3:  // 1 1 0
    case 4:  // 0 0 1
        g_value_set_string(b, "Блок-значение");
        return true;
    }
    g_value_set_string(b, "Блок для чтения-записи");
    return true;
}

void CMifareClassicDialog::on_user_data_column_view_activate(guint pos) {
    const Gdk::Rectangle rect(0, 0, m_UserDataColumnView.get_width(),
                              m_UserDataColumnView.get_height());
    auto nBits = m_UserDataListStore->get_item(pos)->m_property_bits.get_value();
    auto pModel = dynamic_cast<Gtk::SingleSelection*>(m_PUserDataColumnView.get_model().get());
    auto nIdx = FindPUserDataBits(nBits);
    if (nIdx != GTK_INVALID_LIST_POSITION)
        pModel->select_item(nIdx, true);
    m_UserDataPopover.set_pointing_to(rect);
    m_UserDataPopover.set_visible(true);
}

void CMifareClassicDialog::on_popover_user_data_column_view_activate(guint pos) {
    m_UserDataPopover.set_visible(false);
    auto item = m_PUserDataListStore->get_item(pos);
    if (item != nullptr)
        SetSectorAreaAccess(m_nSectorIdx, item->m_property_area, item->m_property_bits);
}

void CMifareClassicDialog::on_button_read() {
    ReadCardData();
}

void CMifareClassicDialog::on_button_write() {
    WriteCardData();
}

void CMifareClassicDialog::on_button_errors() {
    ShowErrorsDialog();
}

void CMifareClassicDialog::on_dialog_response(int) {
    m_refDialog = nullptr;
}

void CMifareClassicDialog::on_error_dialog_hide() {
    m_refErrorDialog = nullptr;
}

void CMifareClassicDialog::on_hide() {
    m_oReader.Close();
    UpdateAuthGroupData(true);
    g_AppSet.SetDataFormat(m_CardDataGrid.get_byte_format());
    g_AppSet.SetMcAuthKey(m_AuthKey);
    g_AppSet.SetMfAuthRdKeys(m_fAuthByRdKeys);
    g_AppSet.SetMfAuthKeyB(m_fAuthKeyB);
}

void CMifareClassicDialog::ReadCardData() {
    // Перечитываем все сектора
    for (auto& oSector : m_oSectors) {
        oSector.m_fAuthOk = false;
        oSector.m_fReadDataOk = false;
        oSector.m_nInitBlocks = 0;
    }
    ReadCardData(0, m_oSectors.size());
}

void CMifareClassicDialog::ReadCardData(uint nSectorIdx, uint nSectorCount) {
    UpdateAuthGroupData(true);

    try {
        auto nEndSectorIdx = (nSectorIdx + nSectorCount);
        size_t nSBlockCount, nBlockIdx, nKeyTypeIdx, c, nIdx, nRead, nTrailerIdx;
        uint32_t nTrailerAccess;
        // Цикл по секторам, которые нужно прочитать
        for (size_t i = nSectorIdx; i < nEndSectorIdx; i++) {
            auto& oSector = m_oSectors[i];
            nSBlockCount = ilr::GetMfSectorBlockCount(i);

            // Если данные ещё не прочитаны,
            if (!oSector.m_fReadDataOk) {
                nBlockIdx = ilr::GetMfBlockBySector(i);

                oSector.m_aKeyInit[0] = false;
                oSector.m_aKeyInit[1] = false;
                oSector.m_fAuthOk = false;
                oSector.m_fKeyB = m_fAuthKeyB;
                if (m_fAuthByRdKeys) {
                    nKeyTypeIdx = (oSector.m_fKeyB ? 1 : 0);
                    // Если есть выбранные ключи,
                    if (m_refSets->m_aMcCheckRdKeys[nKeyTypeIdx] != 0) {
                        oSector.m_nRdKeyIdx = m_oReader.AuthMfCard2(
                            nBlockIdx, oSector.m_fKeyB, m_refSets->m_aMcCheckRdKeys[nKeyTypeIdx]);
                        oSector.m_fAuthOk = (oSector.m_nRdKeyIdx != -1);
                    }
                }
                else {
                    oSector.m_nRdKeyIdx = -1;
                    oSector.m_AuthKey = m_AuthKey;
                    m_oReader.LoadMfCKey(oSector.m_AuthKey);
                    oSector.m_fAuthOk = m_oReader.AuthMfCard(nBlockIdx, oSector.m_fKeyB);
                }

                if (oSector.m_fAuthOk) {
                    oSector.m_nInitBlocks = 0;
                    c = 0;
                    do {
                        nIdx = (nBlockIdx + c);
                        nRead = 0;
                        try {
                            m_oReader.ReadMfClassic(nIdx, &m_oOldBlocks[nIdx], nSBlockCount - c,
                                                    &nRead);
                        }
                        catch (const std::exception& e) {
                            // std::cerr << e.what() << '\n';
                            AddErrorMessage(Glib::ustring::sprintf(
                                "Не удалось прочитать блок %d: %s", nIdx + nRead, e.what()));
                        }
                        if (nRead > 0) {
                            size_t nEnd = (c + nRead);
                            for (size_t j = c; j < nEnd; j++)
                                SET_BIT(oSector.m_nInitBlocks, j, true);
                            memcpy(&m_oNewBlocks[nIdx], &m_oOldBlocks[nIdx], 16 * nRead);
                        }
                        // Если удалось прочитать не все блоки,
                        if (nRead != (nSBlockCount - c))
                            ++c;  // Пропускаем следующий блок, который не удалось прочитать
                        c += nRead;
                    }
                    while (c < nSBlockCount);
                    oSector.m_fReadDataOk = true;

                    // Устанавливаем ключ в байты блока-прицепа
                    // Если авторизация по ключу считывателя,
                    nKeyTypeIdx = (oSector.m_fKeyB ? 1 : 0);
                    nTrailerIdx = (nBlockIdx + nSBlockCount - 1);
                    if ((oSector.m_nRdKeyIdx != -1) &&
                        GET_BIT(m_refSets->m_aMcValidRdKeys[nKeyTypeIdx], oSector.m_nRdKeyIdx))
                        oSector.m_AuthKey =
                            m_refSets->m_aMcRdKeys[nKeyTypeIdx][oSector.m_nRdKeyIdx].m_Key;
                    if (oSector.m_fKeyB)
                        memcpy(&m_oOldBlocks[nTrailerIdx].a[10], &oSector.m_AuthKey.m_nKey, 6);
                    else
                        memcpy(&m_oOldBlocks[nTrailerIdx].a[0], &oSector.m_AuthKey.m_nKey, 6);
                    m_oNewBlocks[nTrailerIdx] = m_oOldBlocks[nTrailerIdx];
                    oSector.m_aKeyInit[nKeyTypeIdx] = true;
                    // Если авторизация по ключу А,
                    if (!oSector.m_fKeyB) {
                        if (ilr::TryGetMfAreaAccess(ilr::GetMfAccessBits(m_oNewBlocks[nTrailerIdx]),
                                                    3, nTrailerAccess))
                            oSector.m_aKeyInit[1] = CanMfReadKeyB(nTrailerAccess, false);
                    }
                }
                else {  // иначе - не удалось авторизовать
                    AddErrorMessage(Glib::ustring::sprintf("Не удалось авторизовать сектор %d", i));
                }
            }
        }
    }
    catch (const std::exception& e) {
        // std::cerr << e.what() << '\n';
        ShowMessage(e.what(), Gtk::MessageType::ERROR);
    }
    UpdateDataGridColors();
    UpdateValueBlockGroup();
    UpdateSectorConfigGroup();
}

void CMifareClassicDialog::ReadCurrentSector() {
    auto nBlockIdx = m_CardDataGrid.row_to_block_idx(m_CardDataGrid.get_row());
    if (-1 == nBlockIdx)
        return;
    auto nSectorIdx = ilr::GetMfSectorByBlock(nBlockIdx);
    m_oSectors[nSectorIdx].m_fReadDataOk = false;
    ReadCardData(nSectorIdx, 1);
}

void CMifareClassicDialog::ReadCurrentGroup() {
    auto nSectorIdx = ilr::GetMfSectorByBlock(m_CardDataGrid.get_first_visible_block());
    auto nSectorCount = ilr::GetMfSectorByBlock(m_CardDataGrid.get_first_visible_block() +
                                                m_CardDataGrid.get_visible_block_count()) -
                        nSectorIdx;
    auto nEndSectorIdx = (nSectorIdx + nSectorCount);
    for (auto i = nSectorIdx; i < nEndSectorIdx; i++)
        m_oSectors[i].m_fReadDataOk = false;
    ReadCardData(nSectorIdx, nSectorCount);
}

void CMifareClassicDialog::WriteCardData() {
    WriteCardData(0, m_oSectors.size());
}

void CMifareClassicDialog::WriteCardData(uint nSectorIdx, uint nSectorCount) {
    UpdateAuthGroupData(true);

    // Цикл по секторам, которые нужно записать
    size_t nBlockIdx, nSBlockCount, nIdx, nEndBlockIdx;
    uint nChanged;
    bool fOk;
    auto nEndSectorIdx = (nSectorIdx + nSectorCount);
    for (size_t i = nSectorIdx; i < nEndSectorIdx; i++) {
        auto& oSector = m_oSectors[i];
        nBlockIdx = ilr::GetMfBlockBySector(i);
        nSBlockCount = ilr::GetMfSectorBlockCount(i);
        nChanged = 0;
        nIdx = nBlockIdx;
        for (size_t j = 0; j < nSBlockCount; j++, nIdx++) {
            if (GET_BIT(oSector.m_nInitBlocks, j) &&
                (memcmp(m_oOldBlocks[nIdx].a, m_oNewBlocks[nIdx].a, sizeof(m_oOldBlocks[nIdx].a)) !=
                 0))
                SET_BIT(nChanged, j, true);
        }

        if (nChanged != 0) {
            if (oSector.m_nRdKeyIdx != -1)
                fOk = (m_oReader.AuthMfCard2(nBlockIdx, oSector.m_fKeyB,
                                             1 << oSector.m_nRdKeyIdx) != -1);
            else {
                m_oReader.LoadMfCKey(oSector.m_AuthKey);
                fOk = m_oReader.AuthMfCard(nBlockIdx, oSector.m_fKeyB);
            }
            if (fOk) {
                nEndBlockIdx = (nSBlockCount - 1);
                for (size_t j = 0; j < nEndBlockIdx; j++) {
                    if (GET_BIT(nChanged, j)) {
                        nIdx = (nBlockIdx + j);
                        try {
                            m_oReader.WriteMfClassic(nIdx, &m_oNewBlocks[nIdx], 1);
                            m_oOldBlocks[nIdx] = m_oNewBlocks[nIdx];
                        }
                        catch (const std::exception& e) {
                            std::cerr << e.what() << '\n';
                            AddErrorMessage(Glib::ustring::sprintf(
                                "Не удалось записать блок %d: %s", nIdx, e.what()));
                        }
                    }
                }
                // Если блок-прицеп изменён
                if (GET_BIT(nChanged, nSBlockCount - 1)) {
                    // Если один из ключей аутентификации не введён,
                    if (!oSector.m_aKeyInit[0] && (oSector.m_aKeyInit[1])) {
                        // Сообщаем о пропуске записи блока-прицепа
                        AddErrorMessage(Glib::ustring::sprintf(
                            "Ключ сектора %d не введён, блок-прицеп не записан", i));
                    }
                    else {
                        nIdx = (nBlockIdx + nSBlockCount - 1);
                        try {
                            m_oReader.WriteMfClassic(nIdx, &m_oNewBlocks[nIdx], 1);
                            m_oOldBlocks[nIdx] = m_oNewBlocks[nIdx];
                        }
                        catch (const std::exception& e) {
                            std::cerr << e.what() << '\n';
                            AddErrorMessage(Glib::ustring::sprintf(
                                "Не удалось записать блок %d: %s", nIdx, e.what()));
                        }
                    }
                }
            }
            else
                // Сообщаем об ошибке авторизации сектора
                AddErrorMessage(Glib::ustring::sprintf("Не удалось авторизовать сектор %d", i));
        }
    }
    UpdateDataGridColors();
}

void CMifareClassicDialog::WriteSector() {
    auto nBlockIdx = m_CardDataGrid.row_to_block_idx(m_CardDataGrid.get_row());
    auto nSectorIdx = ilr::GetMfSectorByBlock(nBlockIdx);
    WriteCardData(nSectorIdx, 1);
}

void CMifareClassicDialog::WriteGroup() {
    auto nSectorIdx = ilr::GetMfSectorByBlock(m_CardDataGrid.get_first_visible_block());
    auto nSectorCount = ilr::GetMfSectorByBlock(m_CardDataGrid.get_first_visible_block() +
                                                m_CardDataGrid.get_visible_block_count()) -
                        nSectorIdx;
    WriteCardData(nSectorIdx, nSectorCount);
}

void CMifareClassicDialog::SetViewDataRange(uint nFirstBlockIdx, uint nBlockCount) {
    m_nSectorIdx = -1;
    m_CardDataGrid.set_visible_range(nFirstBlockIdx, nBlockCount);
    m_CardDataGrid.update();
    UpdateDataGridColors();
}

void CMifareClassicDialog::SetSectorAreaAccess(uint nSectorIdx, uint nAreaIdx, uint nAreaAccess) {
    auto nBlockIdx = ilr::GetMfBlockBySector(nSectorIdx);
    auto nSBlockCount = ilr::GetMfSectorBlockCount(nSectorIdx);
    auto nTrailerIdx = (nBlockIdx + nSBlockCount - 1);
    auto nSectorAccess = ilr::GetMfAccessBits(m_oNewBlocks[nTrailerIdx]);
    uint32_t nCurrentAreaAccess;
    if (!ilr::TryGetMfAreaAccess(nSectorAccess, nAreaIdx, nCurrentAreaAccess))
        return;
    ilr::SetMfAreaAccess(nAreaIdx, nAreaAccess, nSectorAccess);
    ilr::SetMfAccessBits(nSectorAccess, m_oNewBlocks[nTrailerIdx]);
    m_CardDataGrid.redraw();
    SelectAreaAccess(nAreaIdx, nAreaAccess);
}

void CMifareClassicDialog::SetValueBlockValue(size_t nBlockIdx, int nValue) {
    auto& rBlockData = m_oNewBlocks[nBlockIdx];
    ilr::SetMfValue(rBlockData, nValue);
    m_CardDataGrid.redraw();
    m_fLockUpdate = true;
    m_ValueSpinButton.set_value(nValue);
    m_fLockUpdate = false;
}

void CMifareClassicDialog::SetValueBlockAddress(size_t nBlockIdx, uint nAddress) {
    auto& rBlockData = m_oNewBlocks[nBlockIdx];
    ilr::SetMfValueAddress(rBlockData, nAddress);
    m_CardDataGrid.redraw();
    m_fLockUpdate = true;
    m_AddressSpinButton.set_value(nAddress);
    m_fLockUpdate = false;
}

void CMifareClassicDialog::AddErrorMessage(const Glib::ustring& sMessage, bool fShowDialog) {
    if (nullptr == m_refErrorDialog) {
        m_refErrorDialog.reset(new CErrorsDialog());
        m_refErrorDialog->set_transient_for(*this);
        m_refErrorDialog->set_modal();
        m_refErrorDialog->set_hide_on_close();
        m_refErrorDialog->signal_hide().connect(
            sigc::mem_fun(*this, &CMifareClassicDialog::on_error_dialog_hide));
    }
    m_refErrorDialog->AddMessage(sMessage);
    if (fShowDialog)
        m_refErrorDialog->set_visible(true);
}

void CMifareClassicDialog::ShowErrorsDialog() {
    if (nullptr == m_refErrorDialog) {
        m_refErrorDialog.reset(new CErrorsDialog());
        m_refErrorDialog->set_transient_for(*this);
        m_refErrorDialog->set_modal();
        m_refErrorDialog->set_hide_on_close();
        m_refErrorDialog->signal_hide().connect(
            sigc::mem_fun(*this, &CMifareClassicDialog::on_error_dialog_hide));
    }
    m_refErrorDialog->set_visible(true);
}

void CMifareClassicDialog::UpdateDataGridColors() {
    m_CardDataGrid.clear_byte_attrs();
    auto nEndBlockIdx =
        (m_CardDataGrid.get_first_visible_block() + m_CardDataGrid.get_visible_block_count());
    size_t nSectorIdx, nSBlockIdx, nSBlockCount, nAreaIdx;
    ilr::GetMfBlockInfo(m_CardDataGrid.get_first_visible_block(), nSectorIdx, nSBlockIdx,
                        nSBlockCount);
    uint32_t nAreaAccess;
    auto nSectorAccess = ilr::GetMfAccessBits(
        m_oOldBlocks[m_CardDataGrid.get_first_visible_block() - nSBlockIdx + nSBlockCount - 1]);
    bool fAreaValid;
    uint nAddress = m_CardDataGrid.get_first_visible_block() * 16;
    for (auto i = m_CardDataGrid.get_first_visible_block(); i < nEndBlockIdx; i++) {
        auto& oSector = m_oSectors[nSectorIdx];
        if (GET_BIT(oSector.m_nInitBlocks, nSBlockIdx)) {
            nAreaIdx = (nSBlockIdx * 3) / (nSBlockCount - 1);
            fAreaValid = ilr::TryGetMfAreaAccess(nSectorAccess, nAreaIdx, nAreaAccess);
            if (fAreaValid) {
                // Если это блок-прицеп,
                if (nSBlockIdx == (nSBlockCount - 1)) {
                    // Ключ А
                    m_CardDataGrid.add_or_set_byte_attrs(
                        nAddress, 6, byte_format::BYTE_FORMAT_UNDEF, Gdk::RGBA(0, 0, 0),
                        CanMfWriteKeyA(nAreaAccess, oSector.m_fKeyB) ? m_KeyButton.get_rgba() :
                                                                       m_NrwKeyButton.get_rgba());

                    // Биты доступа
                    m_CardDataGrid.add_or_set_byte_attrs(
                        nAddress + 6, 3, byte_format::BYTE_FORMAT_UNDEF, Gdk::RGBA(0, 0, 0),
                        CanMfWriteAccessBits(nAreaAccess, oSector.m_fKeyB) ?
                            m_AccessBitsButton.get_rgba() :
                            m_AccessBitsRoButton.get_rgba());

                    // Ключ Б
                    m_CardDataGrid.add_or_set_byte_attrs(
                        nAddress + 10, 6, byte_format::BYTE_FORMAT_UNDEF, Gdk::RGBA(0, 0, 0),
                        CanMfWriteKeyB(nAreaAccess, oSector.m_fKeyB) ? m_KeyButton.get_rgba() :
                                                                       m_NrwKeyButton.get_rgba());
                }
                // иначе - блок пользовательских данных
                else {
                    // Если это первый блок, то отмечаем серийный номер
                    if (0 == i) {
                        m_CardDataGrid.add_or_set_byte_attrs(
                            nAddress, m_CardUid.GetLength(), byte_format::BYTE_FORMAT_UNDEF,
                            Gdk::RGBA(0, 0, 0), m_SerialButton.get_rgba(), false);
                        m_CardDataGrid.add_or_set_byte_attrs(
                            nAddress + m_CardUid.GetLength(), 16 - m_CardUid.GetLength(),
                            byte_format::BYTE_FORMAT_UNDEF, Gdk::RGBA(0, 0, 0),
                            CanMfWriteUserData(nAreaAccess, oSector.m_fKeyB) ?
                                m_UserDataButton.get_rgba() :
                                (CanMfReadUserData(nAreaAccess, oSector.m_fKeyB) ?
                                     m_UserDataRoButton.get_rgba() :
                                     m_NrwDataButton.get_rgba()));
                    }
                    else {
                        m_CardDataGrid.add_or_set_byte_attrs(
                            nAddress, 16, byte_format::BYTE_FORMAT_UNDEF, Gdk::RGBA(0, 0, 0),
                            CanMfWriteUserData(nAreaAccess, oSector.m_fKeyB) ?
                                m_UserDataButton.get_rgba() :
                                (CanMfReadUserData(nAreaAccess, oSector.m_fKeyB) ?
                                     m_UserDataRoButton.get_rgba() :
                                     m_NrwDataButton.get_rgba()));
                    }
                }
            }
            else  // биты доступа не корректны
                m_CardDataGrid.add_or_set_byte_attrs(nAddress, 16, byte_format::BYTE_FORMAT_UNDEF,
                                                     Gdk::RGBA(0, 0, 0), m_NrwDataButton.get_rgba(),
                                                     false);
        }
        if (++nSBlockIdx == nSBlockCount) {
            if (++nSectorIdx == m_oSectors.size())
                break;
            nSBlockIdx = 0;
            nSBlockCount = ilr::GetMfSectorBlockCount(nSectorIdx);
            nSectorAccess = ilr::GetMfAccessBits(m_oOldBlocks[i + 1 + nSBlockCount - 1]);
        }
        nAddress += 16;
    }
    m_CardDataGrid.redraw();
}

void CMifareClassicDialog::UpdateGroupListBox() {
    for (auto& oRow : m_GroupListRows)
        m_GroupListBox.remove(oRow);

    auto nCount = m_oSectors.size();
    if (m_oSectors.size() > 32) {
        ++nCount;  // Группа "Малые (до 32)"
        ++nCount;  // Группа "Большие (от 32)"
    }
    ++nCount;  // Группа "Все"
    m_GroupListRows.resize(nCount);

    for (size_t i = 0; i < m_oSectors.size(); i++)
        m_GroupListRows[i].set_text(Glib::ustring::sprintf("Сектор %u", i));

    auto nIdx = m_oSectors.size();
    if (m_oSectors.size() > 32) {
        m_GroupListRows[nIdx++].set_text("Малые (до 32)");
        m_GroupListRows[nIdx++].set_text("Большие (от 32)");
    }
    m_GroupListRows[nIdx++].set_text("Все");

    for (size_t i = 0; i < m_GroupListRows.size(); i++)
        m_GroupListBox.append(m_GroupListRows[i]);

    if (m_CardDataGrid.get_visible_block_count() == m_oOldBlocks.size())
        m_GroupListBox.select_row(m_GroupListRows[m_oSectors.size()]);  // Группа "Все"
    else {
        size_t nSectorIdx, nSBlockIdx, nSBlockCount;
        ilr::GetMfBlockInfo(m_CardDataGrid.get_first_visible_block(), nSectorIdx, nSBlockIdx,
                            nSBlockCount);
        if (m_CardDataGrid.get_visible_block_count() == nSBlockCount)
            m_GroupListBox.select_row(m_GroupListRows[nSectorIdx]);  // Группа "Сектор %u"
        else if (4 == nSBlockCount)
            m_GroupListBox.select_row(m_GroupListRows[nIdx - 3]);  // Группа "Малые (до 32)"
        else
            m_GroupListBox.select_row(m_GroupListRows[nIdx - 2]);  // Группа "Большие (от 32)"
    }
}

void CMifareClassicDialog::UpdateValueBlockGroup() {
    auto nBlockIdx = m_CardDataGrid.row_to_block_idx(m_CardDataGrid.get_row());
    if (-1 == nBlockIdx) {
        m_ValueBlockFrame.set_visible(false);
        return;
    }
    auto nAreaIdx = ilr::GetMfAreaByBlockIdx(nBlockIdx);
    size_t nSectorIdx, nSBlockIdx, nSBlockCount;
    ilr::GetMfBlockInfo(nBlockIdx, nSectorIdx, nSBlockIdx, nSBlockCount);
    m_ValueBlockFrame.set_label(Glib::ustring::sprintf("Блок значение №%u", nBlockIdx));
    auto pTrailerData = &m_oNewBlocks[nBlockIdx - nSBlockIdx + nSBlockCount - 1];
    auto nSectorAccess = ilr::GetMfAccessBits(*pTrailerData);
    uint32_t nAreaAccess;
    auto fOk = ilr::TryGetMfAreaAccess(nSectorAccess, nAreaIdx, nAreaAccess);
    m_ValueBlockFrame.set_sensitive(fOk);
    if (fOk) {
        auto f = (0 == nAreaAccess) || ((3 == nAreaAccess) && m_oSectors[m_nSectorIdx].m_fKeyB);
        m_IncrementButton.set_sensitive(f);
        f = (0 == nAreaAccess) ||
            (m_oSectors[m_nSectorIdx].m_fKeyB &&
             ((1 == nAreaAccess) || (3 == nAreaAccess) || (6 == nAreaAccess)));
        m_ValueSpinButton.set_sensitive(f);
        m_AddressSpinButton.set_sensitive(f);
    }
    auto fShowGroup = fOk && (nAreaIdx != 3) && ((3 == nAreaAccess) || (4 == nAreaAccess));
    m_ValueBlockFrame.set_visible(fShowGroup);
    if (fShowGroup) {
        m_fLockUpdate = true;
        int nValue = 0;
        ilr::TryGetMfValue(m_oNewBlocks[nBlockIdx], nValue);
        m_ValueSpinButton.set_value(nValue);
        uint8_t nAddress = 0;
        ilr::TryGetMfValueAddress(m_oNewBlocks[nBlockIdx], nAddress);
        m_AddressSpinButton.set_value(nAddress);
        m_fLockUpdate = false;
    }
}

void CMifareClassicDialog::UpdateSectorConfigGroup() {
    auto nBlockIdx = m_CardDataGrid.row_to_block_idx(m_CardDataGrid.get_row());
    if (-1 == nBlockIdx) {
        m_nSectorIdx = -1;
        m_SectorFrame.set_sensitive(false);
        return;
    }
    m_SectorFrame.set_sensitive(true);
    size_t nSectorIdx, nSBlockIdx, nSBlockCount;
    ilr::GetMfBlockInfo(nBlockIdx, nSectorIdx, nSBlockIdx, nSBlockCount);
    m_nSectorIdx = nSectorIdx;
    m_SectorFrame.set_label(Glib::ustring::sprintf("Сектор %d", m_nSectorIdx));
    auto& oSector = m_oSectors[m_nSectorIdx];
    auto nCount = m_UserDataListStore->get_n_items();
    for (size_t i = 0; i < nCount; i++)
        m_UserDataListStore->get_item(i)->m_property_area.notify();

    m_SectorKeyAEntry.set_sensitive(oSector.m_fAuthOk);
    m_SectorKeyBEntry.set_sensitive(oSector.m_fAuthOk);

    auto pTrailerData = &m_oNewBlocks[nBlockIdx - nSBlockIdx + nSBlockCount - 1];
    ilr::CMifareClassicKey nAuthKey;
    if (oSector.m_aKeyInit[0]) {
        nAuthKey = ilr::GetMfClassicKey(*pTrailerData, false);
        m_SectorKeyAEntry.set_text(nAuthKey.ToString());
    }
    else
        m_SectorKeyAEntry.set_text("");

    if (oSector.m_aKeyInit[1]) {
        nAuthKey = ilr::GetMfClassicKey(*pTrailerData, true);
        m_SectorKeyBEntry.set_text(nAuthKey.ToString());
    }
    else
        m_SectorKeyBEntry.set_text("");

    auto nSectorAccess = ilr::GetMfAccessBits(*pTrailerData);
    uint32_t nAreaAccess;
    auto fOk = ilr::TryGetMfAreaAccess(nSectorAccess, 3, nAreaAccess);
    if (fOk)
        SelectAreaAccess(3, nAreaAccess);
    m_SectorTrailerFrame.set_sensitive(fOk);

    for (size_t i = 0; i < nCount; i++) {
        fOk = ilr::TryGetMfAreaAccess(nSectorAccess, i, nAreaAccess);
        if (fOk)
            SelectAreaAccess(i, nAreaAccess);
    }
}

void CMifareClassicDialog::UpdateAuthGroupData(bool fSave) {
    if (fSave) {
        m_fAuthKeyB = m_KeyBCheckButton.get_active();
        m_fAuthByRdKeys = m_ReaderKeysCheckButton.get_active();
        m_AuthKey.TryParse(m_ExplicitKeyEntry.get_text().c_str());
    }
    else {
        if (m_fAuthKeyB)
            m_KeyBCheckButton.set_active();
        else
            m_KeyACheckButton.set_active();
        if (m_fAuthByRdKeys)
            m_ReaderKeysCheckButton.set_active();
        else
            m_ExplicitKeyCheckButton.set_active();
        m_ExplicitKeyEntry.set_text(m_AuthKey.ToString());
    }
    UpdateAuthRdKeysCtrlData(fSave);
}

void CMifareClassicDialog::UpdateAuthRdKeysCtrlData(bool fSave) {
    auto nKeyTypeIdx = (m_fAuthKeyB ? 1 : 0);
    if (fSave) {
        uint nChecks = 0;
        for (size_t i = 0; i < std::size(m_aReaderKeyCheckButtons); i++)
            if (m_aReaderKeyCheckButtons[i].get_active())
                SET_BIT(nChecks, i, true);
        m_refSets->SetMcCheckRdKeys(nKeyTypeIdx, nChecks);
    }
    else {
        for (size_t i = 0; i < std::size(m_aReaderKeyCheckButtons); i++)
            m_aReaderKeyCheckButtons[i].set_active(
                GET_BIT(m_refSets->m_aMpCheckRdKeys[nKeyTypeIdx], i));
    }
}

void CMifareClassicDialog::SelectFormat(byte_format nFormat) {
    m_CardDataGrid.set_byte_format(nFormat);
    m_fLockUpdate = true;
    switch (nFormat) {
    case byte_format::BYTE_FORMAT_HEX:
        m_HexCheckButton.set_active();
        break;

    case byte_format::BYTE_FORMAT_DEC:
        m_DecCheckButton.set_active();
        break;

    case byte_format::BYTE_FORMAT_OCT:
        m_OctCheckButton.set_active();
        break;

    case byte_format::BYTE_FORMAT_BIN:
        m_BinCheckButton.set_active();
        break;
    }
    m_refFormatAction->change_state((int)nFormat);
    m_fLockUpdate = false;
}

void CMifareClassicDialog::SelectAreaAccess(size_t nAreaIdx, uint32_t nAreaAccess) {
    // Если область блок-прицепа,
    if (3 == nAreaIdx) {
        auto item = m_TrailerListStore->get_item(0);
        item->m_property_bits.set_value(nAreaAccess);
    }
    else {  // иначе - область пользовательских данных
        auto item = m_UserDataListStore->get_item(2 - nAreaIdx);
        item->m_property_bits.set_value(nAreaAccess);
    }
}

void CMifareClassicDialog::configure_trailer_column_view(
    Gtk::ColumnView& ColumnView, Glib::RefPtr<Gio::ListStore<CTrailerModelColumns>>& refListStore,
    bool fPopup) {
    refListStore = Gio::ListStore<CTrailerModelColumns>::create();
    if (fPopup) {
        auto selection_model = Gtk::SingleSelection::create(refListStore);
        selection_model->set_autoselect(false);
        ColumnView.set_model(selection_model);
    }
    else {
        auto selection_model = Gtk::NoSelection::create(refListStore);
        ColumnView.set_model(selection_model);
    }
    ColumnView.add_css_class("data-table");  // high density table
    ColumnView.set_single_click_activate();

    // Столбец "Биты"
    auto factory = Gtk::SignalListItemFactory::create();
    factory->signal_setup().connect(sigc::mem_fun(*this, &CMifareClassicDialog::on_setup_label));
    factory->signal_bind().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_trailer_bind_bits));
    auto column = Gtk::ColumnViewColumn::create("Биты", factory);
    ColumnView.append_column(column);

    // Столбец "Чтение А"
    factory = Gtk::SignalListItemFactory::create();
    factory->signal_setup().connect(sigc::mem_fun(*this, &CMifareClassicDialog::on_setup_label));
    factory->signal_bind().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_trailer_bind_read_a));
    column = Gtk::ColumnViewColumn::create("Чтение А", factory);
    ColumnView.append_column(column);

    // Столбец "Запись А"
    factory = Gtk::SignalListItemFactory::create();
    factory->signal_setup().connect(sigc::mem_fun(*this, &CMifareClassicDialog::on_setup_label));
    factory->signal_bind().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_trailer_bind_write_a));
    column = Gtk::ColumnViewColumn::create("Запись А", factory);
    ColumnView.append_column(column);

    // Столбец "Чтение доступа"
    factory = Gtk::SignalListItemFactory::create();
    factory->signal_setup().connect(sigc::mem_fun(*this, &CMifareClassicDialog::on_setup_label));
    factory->signal_bind().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_trailer_bind_read_access));
    column = Gtk::ColumnViewColumn::create("Чтение доступа", factory);
    ColumnView.append_column(column);

    // Столбец "Запись доступа"
    factory = Gtk::SignalListItemFactory::create();
    factory->signal_setup().connect(sigc::mem_fun(*this, &CMifareClassicDialog::on_setup_label));
    factory->signal_bind().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_trailer_bind_write_access));
    column = Gtk::ColumnViewColumn::create("Запись доступа", factory);
    ColumnView.append_column(column);

    // Столбец "Чтение Б"
    factory = Gtk::SignalListItemFactory::create();
    factory->signal_setup().connect(sigc::mem_fun(*this, &CMifareClassicDialog::on_setup_label));
    factory->signal_bind().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_trailer_bind_read_b));
    column = Gtk::ColumnViewColumn::create("Чтение Б", factory);
    ColumnView.append_column(column);

    // Столбец "Запись Б"
    factory = Gtk::SignalListItemFactory::create();
    factory->signal_setup().connect(sigc::mem_fun(*this, &CMifareClassicDialog::on_setup_label));
    factory->signal_bind().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_trailer_bind_write_b));
    column = Gtk::ColumnViewColumn::create("Запись Б", factory);
    ColumnView.append_column(column);

    // Столбец "Примечание"
    factory = Gtk::SignalListItemFactory::create();
    factory->signal_setup().connect(sigc::mem_fun(*this, &CMifareClassicDialog::on_setup_label));
    factory->signal_bind().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_trailer_bind_remark));
    column = Gtk::ColumnViewColumn::create("Примечание", factory);
    ColumnView.append_column(column);
    if (fPopup) {
        refListStore->append(CTrailerModelColumns::create(0));
        refListStore->append(CTrailerModelColumns::create(2));
        refListStore->append(CTrailerModelColumns::create(1));
        refListStore->append(CTrailerModelColumns::create(3));
        refListStore->append(CTrailerModelColumns::create(4));
        refListStore->append(CTrailerModelColumns::create(6));
        refListStore->append(CTrailerModelColumns::create(5));
        refListStore->append(CTrailerModelColumns::create(7));
    }
    else
        refListStore->append(CTrailerModelColumns::create(0));
}

guint CMifareClassicDialog::FindPTrailerBits(uint nBits) const {
    auto nCount = m_PTrailerListStore->get_n_items();
    for (guint i = 0; i < nCount; i++)
        if (m_PTrailerListStore->get_item(i)->m_property_bits.get_value() == nBits)
            return i;
    return GTK_INVALID_LIST_POSITION;
}

void CMifareClassicDialog::configure_userdata_column_view(
    Gtk::ColumnView& ColumnView, Glib::RefPtr<Gio::ListStore<CUserDataModelColumns>>& refListStore,
    bool fPopup) {
    // Create the List model:
    refListStore = Gio::ListStore<CUserDataModelColumns>::create();
    // Set list model and selection model.
    if (fPopup) {
        auto selection_model = Gtk::SingleSelection::create(refListStore);
        selection_model->set_autoselect(false);
        ColumnView.set_model(selection_model);
    }
    else {
        auto selection_model = Gtk::NoSelection::create(refListStore);
        ColumnView.set_model(selection_model);
    }
    ColumnView.add_css_class("data-table");  // high density table
    ColumnView.set_single_click_activate();

    // Add the ColumnView's columns:

    Glib::RefPtr<Gtk::SignalListItemFactory> factory;
    Glib::RefPtr<Gtk::ColumnViewColumn> column;

    if (!fPopup) {
        // Столбец "Блоки"
        factory = Gtk::SignalListItemFactory::create();
        factory->signal_setup().connect(
            sigc::mem_fun(*this, &CMifareClassicDialog::on_setup_label));
        factory->signal_bind().connect(
            sigc::mem_fun(*this, &CMifareClassicDialog::on_user_data_bind_area));
        column = Gtk::ColumnViewColumn::create("Блоки", factory);
        ColumnView.append_column(column);
    }

    // Столбец "Биты"
    factory = Gtk::SignalListItemFactory::create();
    factory->signal_setup().connect(sigc::mem_fun(*this, &CMifareClassicDialog::on_setup_label));
    factory->signal_bind().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_user_data_bind_bits));
    column = Gtk::ColumnViewColumn::create("Биты", factory);
    ColumnView.append_column(column);

    // Столбец "Чтение"
    factory = Gtk::SignalListItemFactory::create();
    factory->signal_setup().connect(sigc::mem_fun(*this, &CMifareClassicDialog::on_setup_label));
    factory->signal_bind().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_user_data_bind_read));
    column = Gtk::ColumnViewColumn::create("Чтение", factory);
    ColumnView.append_column(column);

    // Столбец "Запись"
    factory = Gtk::SignalListItemFactory::create();
    factory->signal_setup().connect(sigc::mem_fun(*this, &CMifareClassicDialog::on_setup_label));
    factory->signal_bind().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_user_data_bind_write));
    column = Gtk::ColumnViewColumn::create("Запись", factory);
    ColumnView.append_column(column);

    // Столбец "Инкремент"
    factory = Gtk::SignalListItemFactory::create();
    factory->signal_setup().connect(sigc::mem_fun(*this, &CMifareClassicDialog::on_setup_label));
    factory->signal_bind().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_user_data_bind_increment));
    column = Gtk::ColumnViewColumn::create("Инкремент", factory);
    ColumnView.append_column(column);

    // Столбец "Д/П/В"
    factory = Gtk::SignalListItemFactory::create();
    factory->signal_setup().connect(sigc::mem_fun(*this, &CMifareClassicDialog::on_setup_label));
    factory->signal_bind().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_user_data_bind_dtr));
    column = Gtk::ColumnViewColumn::create("Д/П/В", factory);
    ColumnView.append_column(column);

    // Столбец "Примечание"
    factory = Gtk::SignalListItemFactory::create();
    factory->signal_setup().connect(sigc::mem_fun(*this, &CMifareClassicDialog::on_setup_label));
    factory->signal_bind().connect(
        sigc::mem_fun(*this, &CMifareClassicDialog::on_user_data_bind_remark));
    column = Gtk::ColumnViewColumn::create("Примечание", factory);
    ColumnView.append_column(column);

    if (fPopup) {
        refListStore->append(CUserDataModelColumns::create(0, 0));
        refListStore->append(CUserDataModelColumns::create(2, 0));
        refListStore->append(CUserDataModelColumns::create(1, 0));
        refListStore->append(CUserDataModelColumns::create(3, 0));
        refListStore->append(CUserDataModelColumns::create(4, 0));
        refListStore->append(CUserDataModelColumns::create(6, 0));
        refListStore->append(CUserDataModelColumns::create(5, 0));
        refListStore->append(CUserDataModelColumns::create(7, 0));
    }
    else {
        refListStore->append(CUserDataModelColumns::create(0, 2));
        refListStore->append(CUserDataModelColumns::create(0, 1));
        refListStore->append(CUserDataModelColumns::create(0, 0));
    }
}

guint CMifareClassicDialog::FindPUserDataBits(uint nBits) const {
    auto nCount = m_PUserDataListStore->get_n_items();
    for (guint i = 0; i < nCount; i++)
        if (m_PUserDataListStore->get_item(i)->m_property_bits.get_value() == nBits)
            return i;
    return GTK_INVALID_LIST_POSITION;
}

void CMifareClassicDialog::ShowMessage(const std::string& sMessage, Gtk::MessageType nType) {
    if (nullptr == m_refDialog)
        m_refDialog.reset(new Gtk::MessageDialog("Демо", false, nType));
    m_refDialog->set_transient_for(*this);
    m_refDialog->set_message(sMessage);
    m_refDialog->show();
    m_refDialog->signal_response().connect(
        sigc::bind(sigc::mem_fun(*this, &CMifareClassicDialog::on_dialog_response)));
}
