#include "CErrorsDialog.h"

CErrorsDialog::CErrorsDialog() {
    set_destroy_with_parent(true);

    set_title("Сообщения об ошибках");
    set_default_size(400, 400);

    set_child(m_ScrolledWindow);
    m_ScrolledWindow.set_margin(5);
    m_ScrolledWindow.set_policy(Gtk::PolicyType::AUTOMATIC, Gtk::PolicyType::AUTOMATIC);
    m_ScrolledWindow.set_expand();
    m_ScrolledWindow.set_child(m_TextView);
    m_refBuffer = Gtk::TextBuffer::create();
    m_TextView.set_buffer(m_refBuffer);
    m_TextView.set_editable(false);
    m_TextView.set_wrap_mode(Gtk::WrapMode::WORD);
}

CErrorsDialog::~CErrorsDialog() {
}

void CErrorsDialog::AddMessage(const Glib::ustring& sMessage) {
    m_refBuffer->insert(m_refBuffer->end(), sMessage);
    auto mark = m_refBuffer->end();
    m_TextView.scroll_to(mark);
}
