#include "CTimeZoneDialog.h"

#include "utils.h"

CTimeZoneDialog::CTimeZoneDialog() :
    m_fModeTz(false),
    m_fOut(false),
    m_nIdx(-1),
    m_fAccept(false),
    m_DowsFrame("Дни недели"),
    m_DowsBox(Gtk::Orientation::VERTICAL),
    m_aDowCheckButtons(Gtk::CheckButton("Понедельник"), Gtk::CheckButton("Вторник"),
                       Gtk::CheckButton("Среда"), Gtk::CheckButton("Четверг"),
                       Gtk::CheckButton("Пятница"), Gtk::CheckButton("Суббота"),
                       Gtk::CheckButton("Воскресенье")),
    m_TimeFrame("Время"),
    m_FromLabel("с"),
    m_refFromHourAdjustment(Gtk::Adjustment::create(0, 0, 23.0)),
    m_refFromMinuteAdjustment(Gtk::Adjustment::create(0, 0, 59.0)),
    m_FromSepLabel(":"),
    m_ToLabel("по"),
    m_refToHourAdjustment(Gtk::Adjustment::create(0, 0, 23.0)),
    m_refToMinuteAdjustment(Gtk::Adjustment::create(0, 0, 59.0)),
    m_ToSepLabel(":"),
    m_ModeFrame("Режим контроллера"),
    m_CancelButton("Отмена"),
    m_OkButton("OK") {
    memset(&m_rTz, 0, sizeof(m_rTz));
    memset(&m_rModeTz, 0, sizeof(m_rModeTz));

    set_destroy_with_parent(true);
    set_title("Временная зона контроллера");
    set_default_size(345, 210);

    set_child(m_Grid);
    m_Grid.set_margin(5);
    m_Grid.set_row_spacing(10);
    m_Grid.set_column_spacing(10);
    m_Grid.attach(m_DowsFrame, 0, 0, 1, 2);
    m_Grid.attach(m_TimeFrame, 1, 0);
    m_Grid.attach(m_ModeFrame, 1, 1);
    m_Grid.attach_next_to(m_BottomBox, Gtk::PositionType::BOTTOM, 2);

    m_DowsFrame.set_child(m_DowsBox);
    m_DowsBox.set_margin(5);
    for (size_t i = 0; i < std::size(m_aDowCheckButtons); i++)
        m_DowsBox.append(m_aDowCheckButtons[i]);

    m_TimeFrame.set_child(m_TimeBox);
    m_TimeBox.set_margin(5);
    m_TimeBox.set_spacing(5);
    m_TimeBox.append(m_FromLabel);
    // m_FromLabel.set_margin(5);
    m_aFromSpinButton[0].set_orientation(Gtk::Orientation::VERTICAL);
    m_aFromSpinButton[0].set_adjustment(m_refFromHourAdjustment);
    m_TimeBox.append(m_aFromSpinButton[0]);
    m_TimeBox.append(m_FromSepLabel);
    // m_FromSepLabel.set_margin(5);
    m_aFromSpinButton[1].set_orientation(Gtk::Orientation::VERTICAL);
    m_aFromSpinButton[1].set_adjustment(m_refFromMinuteAdjustment);
    m_TimeBox.append(m_aFromSpinButton[1]);
    m_TimeBox.append(m_ToLabel);
    // m_ToLabel.set_margin(5);
    m_aToSpinButton[0].set_orientation(Gtk::Orientation::VERTICAL);
    m_aToSpinButton[0].set_adjustment(m_refToHourAdjustment);
    m_TimeBox.append(m_aToSpinButton[0]);
    m_TimeBox.append(m_ToSepLabel);
    // m_ToSepLabel.set_margin(5);
    m_aToSpinButton[1].set_orientation(Gtk::Orientation::VERTICAL);
    m_aToSpinButton[1].set_adjustment(m_refToMinuteAdjustment);
    m_TimeBox.append(m_aToSpinButton[1]);

    m_ModeFrame.set_child(m_ModeDropDown);
    m_ModeDropDown.set_margin(5);
    m_ModeDropDown.set_hexpand();
    Glib::OptionGroup::vecustrings oStrings;
    oStrings.reserve(std::size(kControllerModeNames));
    oStrings.emplace_back(kControllerModeNames[ILG_CONTROLLER_MODE_INACTIVE]);
    for (size_t i = ILG_CONTROLLER_MODE_BLOCK; i < std::size(kControllerModeNames); i++)
        oStrings.emplace_back(kControllerModeNames[i]);
    m_refModeStringList = Gtk::StringList::create(oStrings);
    m_ModeDropDown.set_model(m_refModeStringList);

    m_BottomBox.set_margin(5);
    m_BottomBox.set_spacing(5);
    m_BottomBox.append(m_CancelButton);
    m_BottomBox.append(m_OkButton);
    m_BottomBox.set_valign(Gtk::Align::END);
    m_BottomBox.set_vexpand(true);
    m_BottomBox.set_halign(Gtk::Align::END);

    m_CancelButton.signal_clicked().connect(
        sigc::mem_fun(*this, &CTimeZoneDialog::on_button_cancel));
    m_OkButton.signal_clicked().connect(sigc::mem_fun(*this, &CTimeZoneDialog::on_button_ok));
}

CTimeZoneDialog::~CTimeZoneDialog() {
}

void CTimeZoneDialog::on_button_cancel() {
    set_visible(false);
}

void CTimeZoneDialog::on_button_ok() {
    UpdateCtrlData(true);
    m_fAccept = true;
    set_visible(false);
}

void CTimeZoneDialog::UpdateCtrlData(bool fSave) {
    if (fSave) {
        uint nDows = 0;
        for (size_t i = 0; i < std::size(m_aDowCheckButtons); i++)
            if (m_aDowCheckButtons[i].get_active())
                nDows |= (1 << i);
        uint8_t nBeginHour, nBeginMinute, nEndHour, nEndMinute;
        nBeginHour = static_cast<uint8_t>(m_aFromSpinButton[0].get_value_as_int());
        nBeginMinute = static_cast<uint8_t>(m_aFromSpinButton[1].get_value_as_int());
        nEndHour = static_cast<uint8_t>(m_aToSpinButton[0].get_value_as_int());
        nEndMinute = static_cast<uint8_t>(m_aToSpinButton[1].get_value_as_int());

        if (m_fModeTz) {
            m_rModeTz.nDaysOfWeek = static_cast<uint8_t>(nDows);
            m_rModeTz.nBeginHour = nBeginHour;
            m_rModeTz.nBeginMinute = nBeginMinute;
            m_rModeTz.nEndHour = nEndHour;
            m_rModeTz.nEndMinute = nEndMinute;

            auto nIdx = m_ModeDropDown.get_selected();
            if (nIdx != GTK_INVALID_LIST_POSITION)
                m_rModeTz.nMode = (nIdx > 0) ?
                                      (ilg_controller_mode)(ILG_CONTROLLER_MODE_BLOCK + nIdx - 1) :
                                      ILG_CONTROLLER_MODE_INACTIVE;
        }
        else {
            m_rTz.nDaysOfWeek = static_cast<uint8_t>(nDows);
            m_rTz.nBeginHour = nBeginHour;
            m_rTz.nBeginMinute = nBeginMinute;
            m_rTz.nEndHour = nEndHour;
            m_rTz.nEndMinute = nEndMinute;
        }
    }
    else {
        uint nDows;
        uint8_t nBeginHour, nBeginMinute, nEndHour, nEndMinute;
        ilg_controller_mode nMode;
        if (m_fModeTz) {
            nDows = m_rModeTz.nDaysOfWeek;
            nBeginHour = m_rModeTz.nBeginHour;
            nBeginMinute = m_rModeTz.nBeginMinute;
            nEndHour = m_rModeTz.nEndHour;
            nEndMinute = m_rModeTz.nEndMinute;
            nMode = m_rModeTz.nMode;
        }
        else {
            nDows = m_rTz.nDaysOfWeek;
            nBeginHour = m_rTz.nBeginHour;
            nBeginMinute = m_rTz.nBeginMinute;
            nEndHour = m_rTz.nEndHour;
            nEndMinute = m_rTz.nEndMinute;
            nMode = ILG_CONTROLLER_MODE_INACTIVE;
        }
        for (size_t i = 0; i < std::size(m_aDowCheckButtons); i++)
            m_aDowCheckButtons[i].set_active((nDows >> i) & 1);
        m_aFromSpinButton[0].set_value(nBeginHour);
        m_aFromSpinButton[1].set_value(nBeginMinute);
        m_aToSpinButton[0].set_value(nEndHour);
        m_aToSpinButton[1].set_value(nEndMinute);
        m_ModeDropDown.set_selected(
            (nMode > ILG_CONTROLLER_MODE_NORMAL) ? (guint)(nMode - ILG_CONTROLLER_MODE_NORMAL) : 0);
    }
}

void CTimeZoneDialog::SetTzIdx(bool fModeTz, bool fOut, uint nIdx) {
    m_fModeTz = fModeTz;
    m_fOut = fOut;
    m_nIdx = nIdx;
    m_fAccept = false;

    std::stringstream ss;
    ss << "Временная зона " << (nIdx + 1);
    set_title(ss.str());
    m_ModeFrame.set_visible(fModeTz);

    UpdateCtrlData(false);
}
