#pragma once
#include <gtkmm.h>

#include "ilguard/ilg_cpp_helpers.h"
#include "ilguard/ilguard.h"

/**
 * Окно "Режим Пожар" для настройки противопожарного режима
 */
class CFireDialog : public Gtk::Window {
public:
    CFireDialog();
    ~CFireDialog() override;

    void Init(const ilg::CController& oController);

protected:
    void on_button_read();
    void on_button_write();

    void DoRead();
    void DoWrite();
    void UpdateCtrlData(bool fSave);

protected:
    ilg::CController m_oController;  // Контроллер
    uint m_nSrcMask;
    int m_nLimitT;

    Gtk::Grid m_Grid;
    Gtk::CheckButton m_ExternalCheckButton;  // Флажок "Внешний сигнал"
    Gtk::CheckButton m_TempCheckButton;  // Флажок "Температурный датчик"
    Gtk::Label m_LimitLabel;             // Метка "Пороговая температура:"
    Glib::RefPtr<Gtk::Adjustment> m_refLimitAdjustment;
    Gtk::SpinButton m_LimitSpinButton;
    Gtk::Box m_ButtonsBox;
    Gtk::Button m_ReadButton;   // Кнопка "Читать"
    Gtk::Button m_WriteButton;  // Кнопка "Записать"
};
