#pragma once
#include <gtkmm.h>

#include "CEcDialog.h"
#include "CEventsDialog.h"
#include "CFireDialog.h"
#include "CKeysDialog.h"
#include "CLockDialog.h"
#include "CMonitorDialog.h"
#include "CProgressDialog.h"
#include "CScheduleDialog.h"
#include "CSecurityDialog.h"
#include "ilguard/ilg_cpp_helpers.h"
#include "ilguard/ilguard.h"

class CControllerDialog : public Gtk::Window {
public:
    CControllerDialog();
    ~CControllerDialog() override;

    void SetController(ilg::CController& oController);

protected:
    void on_button_connect();
    void on_button_disconnect();
    void on_button_setfw();
    void on_fw_dialog_response(int response_id, Gtk::FileChooserDialog* dialog);
    void on_setfw_dialog_response(int response_id);
    void on_progress_dialog_cancel();
    bool on_progress_dialog_progress(size_t& nCurrent, size_t& nTotal);
    void on_progress_dialog_hide();
    void on_button_setaddress();
    void on_button_lock();
    void on_lock_dialog_hide();
    void on_button_schedule();
    void on_schedule_dialog_hide();
    void on_button_keys();
    void on_keys_dialog_hide();
    void on_button_fire();
    void on_fire_dialog_hide();
    void on_button_security();
    void on_security_dialog_hide();
    void on_button_ec();
    void on_ec_dialog_hide();
    void on_button_read_cfg();
    void on_save_cfg_dialog_response(int response_id, Gtk::FileChooserDialog* dialog);
    void on_button_write_cfg();
    void on_load_cfg_dialog_response(int response_id, Gtk::FileChooserDialog* dialog);
    void on_button_read_mode();
    void on_button_write_mode();
    void on_button_open();
    void on_button_open_exit();
    void on_button_fire_on();
    void on_button_fire_off();
    void on_button_security_on();
    void on_button_security_off();
    void on_button_alarm_on();
    void on_button_alarm_off();
    void on_button_power_on();
    void on_button_power_off();
    void on_button_events();
    void on_events_dialog_hide();
    void on_button_monitor();
    void on_monitor_dialog_hide();

    static void ILG_CALL on_ilg_message(ilg_controller_msg nMsg, const void* pMsgData,
                                        void* pUserData);
    void on_ilg();

    void UpdateConnectionStatus();
    void UpdateControllerInfo();
    void MessageDialog(const std::string& sMessage, Gtk::MessageType nType = Gtk::MessageType::INFO,
                       Gtk::ButtonsType nButtons = Gtk::ButtonsType::OK,
                       Gio::ActionMap::ActivateWithIntParameterSlot&& slot =
                           Gio::ActionMap::ActivateWithIntParameterSlot());
    // Возвращает расширение файла конфигурации контроллера по модели контроллера
    std::string GetCtrConfigExtFromModel(ilg_controller_model nModel);
    void EnableExtAskPolling(bool fEnable = true);
    void UpdateExtAskParams();

protected:
    ilg::CController m_oController;  // Контроллер
    ilg::CAsyncCommand m_oCommand;
    Glib::Dispatcher m_oDisp;  // Для синхронизации Callback-функций SDK Guard

    Gtk::Box m_VBox;    // Основная панель
    Gtk::Box m_TopBox;  // Верхняя панель
    Gtk::Box m_StatusBox;  // Панель внутри группы "Состояние подключения"
    Gtk::Frame m_StatusFrame;  // Группа "Состояние подключения"
    Gtk::Label m_StatusLabel;  // Текстовая метка в группе "Состояние подключения"
    Gtk::Button m_ConnectButton;     // Кнопка "Подключиться"
    Gtk::Button m_DisconnectButton;  // Кнопка "Отключиться"
    Gtk::Button m_SetFwButton;       // Кнопка "Установить прошивку"
    Gtk::Box m_BottomBox;            // Нижняя панель
    Gtk::Frame m_LinesFrame;         // Группа "Строки"
    Gtk::ScrolledWindow m_LinesScrolledWindow;
    Gtk::TextView m_LinesTextView;
    Glib::RefPtr<Gtk::TextBuffer> m_refLinesBuffer;
    Glib::RefPtr<Gtk::MessageDialog> m_refDialog;
    Gtk::Box m_Box1;            // Панель настроек
    Gtk::Frame m_AddressFrame;  // Группа "Сетевой адрес"
    Gtk::Box m_AddressBox;
    Glib::RefPtr<Gtk::Adjustment> m_refAddressAdjustment;
    Gtk::SpinButton m_AddressSpinButton;
    Gtk::Button m_SetAddressButton;
    Gtk::Frame m_ParamsFrame;  // Группа "Параметры"
    Gtk::Box m_ParamsBox;
    Gtk::Button m_LockButton;      // Кнопка "Замок..."
    Gtk::Button m_ScheduleButton;  // Кнопка "Расписание..."
    Gtk::Button m_KeysButton;      // Кнопка "Ключи..."
    Gtk::Button m_FireButton;      // Кнопка "Пожар..."
    Gtk::Button m_SecurityButton;  // Кнопка "Охрана..."
    Gtk::Button m_EcButton;        // Кнопка "Электро контроль..."
    Gtk::Button m_ReadCfgButton;   // Кнопка "Читать конфигурацию..."
    std::vector<uint8_t> m_oCfgData;
    Gtk::Button m_WriteCfgButton;  // Кнопка "Писать конфигурацию..."
    Gtk::Frame m_ModeFrame;        // Группа "Режим контроллера"
    Gtk::Grid m_ModeGrid;
    Glib::RefPtr<Gtk::StringList> m_refModeStringList;
    Gtk::DropDown m_oModeDropDown;  // Выпадающий список "Режим контроллера"
    Gtk::Button m_ReadModeButton;   // Кнопка "Читать"
    Gtk::Button m_WriteModeButton;  // Кнопка "Записать"
    Gtk::Box m_Box2;                // Панель управления и журнала
    Gtk::Frame m_ControlFrame;      // Группа "Управление"
    Gtk::Box m_ControlBox;
    Gtk::Button m_OpenButton;         // Кнопка "Открыть дверь"
    Gtk::Button m_OpenExitButton;     // Кнопка "Открыть дверь (выход)"
    Gtk::Button m_FireOnButton;       // Кнопка "Вкл. режим Пожар"
    Gtk::Button m_FireOffButton;      // Кнопка "Выкл. режим Пожар"
    Gtk::Button m_SecurityOnButton;   // Кнопка "Вкл. режим Охрана"
    Gtk::Button m_SecurityOffButton;  // Кнопка "Выкл. режим Охрана"
    Gtk::Button m_AlarmOnButton;      // Кнопка "Вкл. Тревогу"
    Gtk::Button m_AlarmOffButton;     // Кнопка "Выкл. Тревогу"
    Gtk::Button m_PowerOnButton;      // Кнопка "Вкл. Питание"
    Gtk::Button m_PowerOffButton;     // Кнопка "Выкл. Питание"
    Gtk::Frame m_EventsFrame;         // Группа "События"
    Gtk::Box m_EventsBox;
    Gtk::Button m_EventsButton;   // Кнопка "События..."
    Gtk::Button m_MonitorButton;  // Кнопка "Монитор..."
    Gtk::Frame m_ExtAskFrame;     // Группа "ExtAsk"
    Gtk::Box m_ExtAskBox;
    Gtk::Label m_aExtAskLabels[10];
    Gtk::Entry m_aExtAskEntrys[10];
    std::vector<uint8_t> m_oFwData;
    Glib::RefPtr<CProgressDialog> m_refProgressDialog;
    Glib::RefPtr<CLockDialog> m_refLockDialog;
    Glib::RefPtr<CScheduleDialog> m_refScheduleDialog;
    Glib::RefPtr<CKeysDialog> m_refKeysDialog;
    Glib::RefPtr<CFireDialog> m_refFireDialog;
    Glib::RefPtr<CSecurityDialog> m_refSecurityDialog;
    Glib::RefPtr<CEcDialog> m_refEcDialog;
    Glib::RefPtr<CEventsDialog> m_refEventsDialog;
    Glib::RefPtr<CMonitorDialog> m_refMonitorDialog;

    friend void ILG_CALL on_ilg_message(ilg_controller_msg nMsg, const void* pMsgData,
                                        void* pUserData);
};
